/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.rhq.plugin;

import org.apache.commons.logging.Log;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.switchyard.rhq.plugin.model.Metrics;

abstract class BaseSwitchYardResourceComponent<T extends ResourceComponent<?>>
implements ResourceComponent<T> {
    private ResourceContext<T> resourceContext;

    BaseSwitchYardResourceComponent() {
    }

    public void start(ResourceContext<T> context) throws InvalidPluginConfigurationException, Exception {
        this.resourceContext = context;
    }

    protected ResourceContext<T> getResourceContext() {
        return this.resourceContext;
    }

    public void stop() {
    }

    protected abstract Log getLog();

    protected MeasurementDataNumeric getCommonMetric(MeasurementScheduleRequest request, Metrics metrics) {
        String name = request.getName();
        if ("SuccessCount".equals(name)) {
            return new MeasurementDataNumeric(request, Double.valueOf(metrics.getSuccessCount()));
        }
        if ("FaultCount".equals(name)) {
            return new MeasurementDataNumeric(request, Double.valueOf(metrics.getFaultCount()));
        }
        if ("TotalCount".equals(name)) {
            return new MeasurementDataNumeric(request, Double.valueOf(metrics.getTotalCount()));
        }
        if ("TotalProcessingTime".equals(name)) {
            return new MeasurementDataNumeric(request, Double.valueOf(metrics.getTotalTime()));
        }
        if ("AverageProcessingTime".equals(name)) {
            return new MeasurementDataNumeric(request, Double.valueOf(metrics.getAverageTime()));
        }
        if ("MinProcessingTime".equals(name)) {
            return new MeasurementDataNumeric(request, Double.valueOf(metrics.getMinTime()));
        }
        if ("MaxProcessingTime".equals(name)) {
            return new MeasurementDataNumeric(request, Double.valueOf(metrics.getMaxTime()));
        }
        return null;
    }
}

