/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.rhq.plugin;

import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.modules.plugins.jbossas7.json.Operation;
import org.switchyard.rhq.plugin.BaseSwitchYardResourceComponent;
import org.switchyard.rhq.plugin.ComponentServiceResourceComponent;
import org.switchyard.rhq.plugin.model.Application;
import org.switchyard.rhq.plugin.model.ComponentReference;
import org.switchyard.rhq.plugin.model.ComponentReferenceMetrics;
import org.switchyard.rhq.plugin.model.ComponentService;

public class ComponentReferenceResourceComponent
extends BaseSwitchYardResourceComponent<ComponentServiceResourceComponent>
implements MeasurementFacet {
    private static Log LOG = LogFactory.getLog(ComponentReferenceResourceComponent.class);

    @Override
    protected Log getLog() {
        return LOG;
    }

    public AvailabilityType getAvailability() {
        ComponentReference componentReference = this.getComponentReference();
        return componentReference == null ? AvailabilityType.DOWN : AvailabilityType.UP;
    }

    public ComponentReference getComponentReference() {
        String referenceKey = this.getResourceContext().getResourceKey();
        return this.getComponentService().getReferences().get(referenceKey);
    }

    public ComponentService getComponentService() {
        return ((ComponentServiceResourceComponent)this.getResourceContext().getParentResourceComponent()).getComponentService();
    }

    public Application getApplication() {
        return ((ComponentServiceResourceComponent)this.getResourceContext().getParentResourceComponent()).getApplication();
    }

    private ComponentReferenceMetrics getComponentReferenceMetrics() {
        String componentReferenceKey = this.getResourceContext().getResourceKey();
        return ((ComponentServiceResourceComponent)this.getResourceContext().getParentResourceComponent()).getComponentReferenceMetrics().get(componentReferenceKey);
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> requests) throws Exception {
        ComponentReferenceMetrics metrics = this.getComponentReferenceMetrics();
        if (metrics != null) {
            for (MeasurementScheduleRequest request : requests) {
                MeasurementDataNumeric measurementData = this.getCommonMetric(request, metrics);
                if (measurementData != null) {
                    report.addData(measurementData);
                    continue;
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("Unable to collect Component Reference measurement " + request.getName()));
            }
        }
    }

    public <T> T execute(Operation operation, Class<T> clazz) {
        return ((ComponentServiceResourceComponent)this.getResourceContext().getParentResourceComponent()).execute(operation, clazz);
    }
}

