/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.rhq.plugin;

import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.core.pluginapi.operation.OperationFacet;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.modules.plugins.jbossas7.json.Operation;
import org.switchyard.rhq.plugin.BaseSwitchYardResourceComponent;
import org.switchyard.rhq.plugin.ReferenceResourceComponent;
import org.switchyard.rhq.plugin.model.Application;
import org.switchyard.rhq.plugin.model.Gateway;
import org.switchyard.rhq.plugin.model.GatewayMetrics;
import org.switchyard.rhq.plugin.model.Reference;
import org.switchyard.rhq.plugin.operations.StartGateway;
import org.switchyard.rhq.plugin.operations.StopGateway;

public class ReferenceBindingResourceComponent
extends BaseSwitchYardResourceComponent<ReferenceResourceComponent>
implements MeasurementFacet,
OperationFacet {
    private static Log LOG = LogFactory.getLog(ReferenceBindingResourceComponent.class);

    @Override
    protected Log getLog() {
        return LOG;
    }

    public AvailabilityType getAvailability() {
        Gateway gateway = this.getGateway();
        return gateway == null ? AvailabilityType.DOWN : AvailabilityType.UP;
    }

    public Gateway getGateway() {
        String gatewayKey = this.getResourceContext().getResourceKey();
        return ((ReferenceResourceComponent)this.getResourceContext().getParentResourceComponent()).getGateways().get(gatewayKey);
    }

    public Reference getReference() {
        return ((ReferenceResourceComponent)this.getResourceContext().getParentResourceComponent()).getReference();
    }

    public Application getApplication() {
        return ((ReferenceResourceComponent)this.getResourceContext().getParentResourceComponent()).getApplication();
    }

    public GatewayMetrics getGatewayMetrics() {
        String operationKey = this.getResourceContext().getResourceKey();
        return ((ReferenceResourceComponent)this.getResourceContext().getParentResourceComponent()).getGatewayMetrics().get(operationKey);
    }

    public void clearApplications() {
        ((ReferenceResourceComponent)this.getResourceContext().getParentResourceComponent()).clearApplications();
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> requests) throws Exception {
        GatewayMetrics metrics = this.getGatewayMetrics();
        Gateway gateway = this.getGateway();
        if (metrics != null && gateway != null) {
            for (MeasurementScheduleRequest request : requests) {
                MeasurementDataNumeric measurementData = this.getCommonMetric(request, metrics);
                if (measurementData != null) {
                    report.addData(measurementData);
                    continue;
                }
                String name = request.getName();
                if ("State".equals(name)) {
                    report.addData(new MeasurementDataTrait(request, gateway.getState()));
                    continue;
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("Unable to collect Reference Binding measurement " + request.getName()));
            }
        }
    }

    public OperationResult invokeOperation(String name, Configuration parameters) throws InterruptedException, Exception {
        if ("start".equals(name)) {
            Application application;
            String bindingKey = this.getResourceContext().getResourceKey();
            Reference reference = this.getReference();
            if (reference != null && (application = this.getApplication()) != null) {
                String referenceName = reference.getName().toString();
                String applicationName = application.getName().toString();
                this.execute(new StartGateway(applicationName, referenceName, bindingKey, "reference"), Void.class);
                this.clearApplications();
            }
        } else if ("stop".equals(name)) {
            Application application;
            String bindingKey = this.getResourceContext().getResourceKey();
            Reference reference = this.getReference();
            if (reference != null && (application = this.getApplication()) != null) {
                String referenceName = reference.getName().toString();
                String applicationName = application.getName().toString();
                this.execute(new StopGateway(applicationName, referenceName, bindingKey, "reference"), Void.class);
                this.clearApplications();
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.warn((Object)("Unknown Reference Binding operation " + name));
        }
        return null;
    }

    public <T> T execute(Operation operation, Class<T> clazz) {
        return ((ReferenceResourceComponent)this.getResourceContext().getParentResourceComponent()).execute(operation, clazz);
    }
}

