/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.rhq.plugin;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.core.pluginapi.operation.OperationFacet;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.modules.plugins.jbossas7.json.Operation;
import org.switchyard.rhq.plugin.ApplicationResourceComponent;
import org.switchyard.rhq.plugin.BaseSwitchYardResourceComponent;
import org.switchyard.rhq.plugin.model.Application;
import org.switchyard.rhq.plugin.model.Gateway;
import org.switchyard.rhq.plugin.model.GatewayMetrics;
import org.switchyard.rhq.plugin.model.OperationMetrics;
import org.switchyard.rhq.plugin.model.Reference;
import org.switchyard.rhq.plugin.model.ReferenceMetrics;
import org.switchyard.rhq.plugin.operations.ResetReferenceMetrics;

public class ReferenceResourceComponent
extends BaseSwitchYardResourceComponent<ApplicationResourceComponent>
implements MeasurementFacet,
OperationFacet {
    private static Log LOG = LogFactory.getLog(ReferenceResourceComponent.class);

    @Override
    protected Log getLog() {
        return LOG;
    }

    public AvailabilityType getAvailability() {
        Reference reference = this.getReference();
        return reference != null ? AvailabilityType.UP : AvailabilityType.DOWN;
    }

    public Map<String, Gateway> getGateways() {
        Reference reference = this.getReference();
        if (reference == null) {
            return Collections.emptyMap();
        }
        return reference.getGateways();
    }

    public Reference getReference() {
        String referenceKey = this.getResourceContext().getResourceKey();
        return this.getApplication().getReferences().get(referenceKey);
    }

    public Application getApplication() {
        return ((ApplicationResourceComponent)this.getResourceContext().getParentResourceComponent()).getApplication();
    }

    public ReferenceMetrics getReferenceMetrics() {
        String operationKey = this.getResourceContext().getResourceKey();
        Map<String, ReferenceMetrics> referenceMetrics = ((ApplicationResourceComponent)this.getResourceContext().getParentResourceComponent()).getReferenceMetrics();
        return referenceMetrics != null ? referenceMetrics.get(operationKey) : null;
    }

    public Map<String, OperationMetrics> getOperationMetrics() {
        ReferenceMetrics referenceMetrics = this.getReferenceMetrics();
        if (referenceMetrics != null) {
            return referenceMetrics.getOperationMetrics();
        }
        return Collections.emptyMap();
    }

    public Map<String, GatewayMetrics> getGatewayMetrics() {
        ReferenceMetrics serviceMetrics = this.getReferenceMetrics();
        if (serviceMetrics != null) {
            return serviceMetrics.getGatewayMetrics();
        }
        return Collections.emptyMap();
    }

    public void clearReferenceMetrics() {
        ((ApplicationResourceComponent)this.getResourceContext().getParentResourceComponent()).clearReferenceMetrics();
    }

    public void clearApplications() {
        ((ApplicationResourceComponent)this.getResourceContext().getParentResourceComponent()).clearApplications();
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> requests) throws Exception {
        ReferenceMetrics metrics = this.getReferenceMetrics();
        if (metrics != null) {
            for (MeasurementScheduleRequest request : requests) {
                MeasurementDataNumeric measurementData = this.getCommonMetric(request, metrics);
                if (measurementData != null) {
                    report.addData(measurementData);
                    continue;
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("Unable to collect Reference measurement " + request.getName()));
            }
        }
    }

    public OperationResult invokeOperation(String name, Configuration parameters) throws InterruptedException, Exception {
        if ("reset".equals(name)) {
            Reference reference = this.getReference();
            Application application = this.getApplication();
            if (reference != null && application != null) {
                String referenceName = reference.getName().toString();
                String applicationName = application.getName().toString();
                this.execute(new ResetReferenceMetrics(applicationName, referenceName), Void.class);
                this.clearReferenceMetrics();
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.warn((Object)("Unknown Referencs operation " + name));
        }
        return null;
    }

    public <T> T execute(Operation operation, Class<T> clazz) {
        return ((ApplicationResourceComponent)this.getResourceContext().getParentResourceComponent()).execute(operation, clazz);
    }
}

