/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.rhq.plugin;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.switchyard.rhq.plugin.ServiceResourceComponent;
import org.switchyard.rhq.plugin.model.OperationMetrics;
import org.switchyard.rhq.plugin.model.Service;

public class ServiceOperationDiscoveryComponent
implements ResourceDiscoveryComponent<ServiceResourceComponent> {
    private static Log LOG = LogFactory.getLog(ServiceOperationDiscoveryComponent.class);

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<ServiceResourceComponent> context) {
        HashSet<DiscoveredResourceDetails> discoveredResources = new HashSet<DiscoveredResourceDetails>();
        ServiceResourceComponent parent = (ServiceResourceComponent)context.getParentResourceComponent();
        Service service = parent.getService();
        if (service != null) {
            Map<String, OperationMetrics> metrics = parent.getOperationMetrics();
            QName serviceName = service.getName();
            for (String operationName : metrics.keySet()) {
                Configuration pluginConfig = context.getDefaultPluginConfiguration();
                DiscoveredResourceDetails resource = new DiscoveredResourceDetails(context.getResourceType(), operationName, operationName, serviceName.getNamespaceURI(), null, pluginConfig, null);
                discoveredResources.add(resource);
                LOG.debug((Object)("Discovered SwitchYard Service Operation " + operationName));
            }
        }
        return discoveredResources;
    }
}

