/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.rhq.plugin;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.modules.plugins.jbossas7.ASConnection;
import org.rhq.modules.plugins.jbossas7.BaseComponent;
import org.rhq.modules.plugins.jbossas7.json.Operation;
import org.switchyard.rhq.plugin.model.GetVersionResult;
import org.switchyard.rhq.plugin.operations.GetVersion;

public class SwitchYardDiscoveryComponent
implements ResourceDiscoveryComponent<BaseComponent<?>> {
    private static final Log LOG = LogFactory.getLog(SwitchYardDiscoveryComponent.class);
    private static final ObjectMapper mapper = new ObjectMapper();

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<BaseComponent<?>> context) {
        HashSet<DiscoveredResourceDetails> discoveredResources = new HashSet<DiscoveredResourceDetails>();
        GetVersionResult result = SwitchYardDiscoveryComponent.execute((BaseComponent)context.getParentResourceComponent(), new GetVersion(), GetVersionResult.class);
        if (result != null) {
            Configuration pluginConfig = context.getDefaultPluginConfiguration();
            DiscoveredResourceDetails resource = new DiscoveredResourceDetails(context.getResourceType(), "SwitchYardSubsystem", "SwitchYard", result.getVersion(), "Container for SwitchYard Applications", pluginConfig, null);
            discoveredResources.add(resource);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Discovered SwitchYard subsystem for " + context.getPluginContainerName()));
            }
        }
        return discoveredResources;
    }

    public static <T> T execute(BaseComponent<?> server, Operation operation, Class<T> clazz) {
        Object response;
        ASConnection asConnection = server.getASConnection();
        JsonNode jsonNode = asConnection.executeRaw(operation);
        if (jsonNode == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Receiver null response to operation " + operation));
            }
            return null;
        }
        JsonNode outcome = jsonNode.findValue("outcome");
        if (outcome == null || !"success".equals(outcome.asText())) {
            if (LOG.isDebugEnabled()) {
                JsonNode failureDescription = jsonNode.findValue("failure-description");
                if (failureDescription != null) {
                    LOG.debug((Object)("Invocation failed for operation " + operation + ": " + failureDescription.asText()));
                } else {
                    LOG.debug((Object)("Invocation failed for operation " + operation));
                }
            }
            return null;
        }
        JsonNode result = jsonNode.findValue("result");
        if (result == null) {
            return null;
        }
        try {
            response = mapper.readValue(result, clazz);
        }
        catch (Exception ex) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Failure during deserialisation of operation " + operation), (Throwable)ex);
            }
            return null;
        }
        return (T)response;
    }
}

