/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.rhq.plugin.model;

import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.switchyard.rhq.plugin.model.ApplicationNamedMetric;
import org.switchyard.rhq.plugin.model.NamedMetric;
import org.switchyard.rhq.plugin.model.NamedResource;

public class ModelUtil {
    public static <T extends NamedResource> Map<String, T> createNamedResourceMap(T[] resources) {
        if (resources != null && resources.length > 0) {
            TreeMap<String, T> resourceMap = new TreeMap<String, T>();
            for (T resource : resources) {
                resourceMap.put(resource.getName().toString(), resource);
            }
            return resourceMap;
        }
        return Collections.emptyMap();
    }

    public static String toString(Object obj) {
        return obj == null ? null : obj.toString();
    }

    public static <T extends NamedMetric> Map<String, T> createNamedMetricMap(T[] metrics) {
        if (metrics != null && metrics.length > 0) {
            TreeMap<String, T> metricMap = new TreeMap<String, T>();
            for (T resource : metrics) {
                metricMap.put(resource.getName(), resource);
            }
            return metricMap;
        }
        return Collections.emptyMap();
    }

    public static <T extends ApplicationNamedMetric> Map<String, Map<String, T>> createApplicationNamedMetricMap(T[] metrics) {
        if (metrics == null) {
            return Collections.emptyMap();
        }
        TreeMap<String, Map<String, T>> map = new TreeMap<String, Map<String, T>>();
        for (T metric : metrics) {
            String applicationName = metric.getApplication();
            String name = metric.getName();
            TreeMap<String, T> serviceMap = (TreeMap<String, T>)map.get(applicationName);
            if (serviceMap == null) {
                serviceMap = new TreeMap<String, T>();
                map.put(applicationName, serviceMap);
            }
            serviceMap.put(name, metric);
        }
        return map;
    }
}

