/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.rhq.plugin;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.switchyard.rhq.plugin.ApplicationResourceComponent;
import org.switchyard.rhq.plugin.model.Reference;

public class ReferenceDiscoveryComponent
implements ResourceDiscoveryComponent<ApplicationResourceComponent> {
    private static Log LOG = LogFactory.getLog(ReferenceDiscoveryComponent.class);

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<ApplicationResourceComponent> context) {
        HashSet<DiscoveredResourceDetails> discoveredResources = new HashSet<DiscoveredResourceDetails>();
        ApplicationResourceComponent parent = (ApplicationResourceComponent)context.getParentResourceComponent();
        Map<String, Reference> references = parent.getReferences();
        for (Reference reference : references.values()) {
            Configuration pluginConfig = context.getDefaultPluginConfiguration();
            QName name = reference.getName();
            DiscoveredResourceDetails resource = new DiscoveredResourceDetails(context.getResourceType(), name.toString(), name.getLocalPart(), name.getNamespaceURI(), null, pluginConfig, null);
            discoveredResources.add(resource);
            LOG.debug((Object)("Discovered SwitchYard Reference " + reference));
        }
        return discoveredResources;
    }
}

