/*
 * Decompiled with CFR 0.152.
 */
package nux.xom.binary;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import nu.xom.Attribute;
import nu.xom.Comment;
import nu.xom.DocType;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.IllegalAddException;
import nu.xom.Node;
import nu.xom.NodeFactory;
import nu.xom.Nodes;
import nu.xom.ParentNode;
import nu.xom.ProcessingInstruction;
import nu.xom.Text;
import nu.xom.WellformednessException;
import nu.xom.XMLException;
import nux.xom.binary.ArrayByteList;
import nux.xom.binary.ArrayIntList;
import nux.xom.binary.BinaryParsingException;
import nux.xom.binary.LRUHashMap1;
import nux.xom.binary.NodeBuilder;
import nux.xom.binary.StreamingBinaryXMLSerializer;
import nux.xom.binary.Util;
import nux.xom.io.StreamingSerializer;

public class BinaryXMLCodec {
    private NodeFactory factory;
    private String[] symbols;
    private boolean isCompressed;
    private ArrayByteList page;
    private SymbolTable symbolTable;
    private ArrayByteList nodeTokens;
    private ArrayIntList indexData;
    private boolean isFirstPage = true;
    private Inflater decompressor;
    private Deflater compressor;
    private int compressionLevel = -1;
    private Text[] textCache;
    private String[] nameCache;
    private LRUHashMap1 internedNames;
    private NodeBuilder nodeBuilder;
    private OutputStream out;
    private static final int MAX_PAGE_CAPACITY = 65536;
    private static final int TEXT = 0;
    private static final int ATTRIBUTE = 1;
    private static final int BEGIN_ELEMENT = 2;
    private static final int END_ELEMENT = 3;
    private static final int COMMENT = 4;
    private static final int NAMESPACE_DECLARATION = 5;
    private static final int PROCESSING_INSTRUCTION = 6;
    private static final int DOC_TYPE = 7;
    private static final int BNUX_MAGIC = BinaryXMLCodec.createMagicNumber();
    private static final byte VERSION = 7;
    private static final int DOCUMENT_HEADER_SIZE = 5;
    private static final int PAGE_HEADER_SIZE = 20;
    private static final String DOCTYPE_NULL_ID = " ";
    private static final boolean DEBUG = false;

    private void reset() {
        this.internedNames = null;
        this.nodeBuilder = null;
        this.factory = null;
        this.symbolTable = null;
        this.page = null;
        this.nodeTokens = null;
        this.indexData = null;
        this.isFirstPage = true;
        this.out = null;
        try {
            if (this.decompressor != null) {
                this.decompressor.end();
            }
        }
        finally {
            this.decompressor = null;
            try {
                if (this.compressor != null) {
                    this.compressor.end();
                }
            }
            finally {
                this.compressor = null;
            }
        }
    }

    public StreamingSerializer createStreamingSerializer(OutputStream out, int zlibCompressionLevel) {
        return new StreamingBinaryXMLSerializer(this, out, zlibCompressionLevel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBnuxDocument(InputStream input) throws IOException {
        if (input == null) {
            throw new IllegalArgumentException("input stream must not be null");
        }
        if (!input.markSupported()) {
            throw new IllegalArgumentException("markSupported() must be true");
        }
        int magicBytes = 4;
        input.mark(magicBytes);
        try {
            ArrayByteList list = new ArrayByteList(magicBytes);
            if (!list.ensureRemaining(input, magicBytes)) {
                boolean bl = false;
                return bl;
            }
            boolean bl = list.getInt() == BNUX_MAGIC;
            return bl;
        }
        finally {
            input.reset();
        }
    }

    public Document deserialize(byte[] bnuxDocument) throws BinaryParsingException {
        if (bnuxDocument == null) {
            throw new IllegalArgumentException("bnuxDocument must not be null");
        }
        try {
            return this.deserialize(new ByteArrayInputStream(bnuxDocument), null);
        }
        catch (IOException e) {
            throw new BinaryParsingException(e);
        }
    }

    public Document deserialize(InputStream input, NodeFactory factory) throws BinaryParsingException, IOException {
        if (input == null) {
            throw new IllegalArgumentException("input stream must not be null");
        }
        if (factory == null) {
            factory = new NodeFactory();
        }
        if (this.page == null) {
            this.page = new ArrayByteList(256);
        }
        this.page.clear();
        if (!this.page.ensureRemaining(input, 10)) {
            throw new BinaryParsingException("Missing bnux document header");
        }
        int magic = this.page.getInt();
        if (magic != BNUX_MAGIC) {
            throw new BinaryParsingException("Bnux magic number mismatch: " + magic + ", must be: " + BNUX_MAGIC);
        }
        byte version = this.page.get();
        boolean bl = this.isCompressed = version < 0;
        if (this.isCompressed) {
            version = -version;
        }
        if (version != 7) {
            throw new BinaryParsingException("Bnux data format version mismatch: " + version + ", must be: " + 7);
        }
        if (this.isCompressed && this.decompressor == null) {
            this.decompressor = new Inflater();
        }
        if (this.page.get() != 7) {
            throw new BinaryParsingException("Illegal bnux page header marker");
        }
        if (this.internedNames == null) {
            this.internedNames = new LRUHashMap1(128);
        }
        if (this.nodeBuilder == null) {
            this.nodeBuilder = new NodeBuilder();
        }
        this.factory = factory;
        try {
            Document document = this.readDocument(this.page, input);
            return document;
        }
        catch (Throwable t) {
            this.reset();
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof BinaryParsingException) {
                throw (BinaryParsingException)((Object)t);
            }
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            throw new BinaryParsingException(t);
        }
        finally {
            this.symbols = null;
            this.textCache = null;
            this.nameCache = null;
            this.factory = null;
        }
    }

    public byte[] serialize(Document document, int zlibCompressionLevel) throws IllegalArgumentException {
        ByteArrayOutputStream result = new ByteArrayOutputStream(256);
        try {
            this.serialize(document, zlibCompressionLevel, result);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result.toByteArray();
    }

    public void serialize(Document document, int zlibCompressionLevel, OutputStream out) throws IllegalArgumentException, IOException {
        if (document == null) {
            throw new IllegalArgumentException("XOM document must not be null");
        }
        if (zlibCompressionLevel < 0 || zlibCompressionLevel > 9) {
            throw new IllegalArgumentException("Compression level must be 0..9");
        }
        if (out == null) {
            throw new IllegalArgumentException("Output stream must not be null");
        }
        try {
            this.setOutputStream(zlibCompressionLevel, out);
            this.writeDocument(document);
        }
        catch (Throwable t) {
            this.reset();
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            throw new RuntimeException(t);
        }
        finally {
            this.symbolTable = null;
            this.out = null;
        }
    }

    final void setOutputStream(int zlibCompressionLevel, OutputStream out) {
        if (zlibCompressionLevel > 0 && (this.compressor == null || zlibCompressionLevel != this.compressionLevel)) {
            if (this.compressor != null) {
                this.compressor.end();
            }
            this.compressor = new Deflater(zlibCompressionLevel);
        }
        this.compressionLevel = zlibCompressionLevel;
        this.out = out;
    }

    private void readPage(ArrayByteList src, InputStream input) throws BinaryParsingException, IOException {
        int i;
        int symbolTableSize;
        boolean isLastPage;
        if (!src.ensureRemaining(input, 4)) {
            throw new BinaryParsingException("Missing remaining bnux page size");
        }
        int pageSize = src.getInt();
        if (src.remaining() != 0) {
            throw new IllegalStateException("Internal codec bug");
        }
        boolean bl = isLastPage = pageSize < 0;
        if (isLastPage) {
            pageSize = -pageSize;
        }
        if (!isLastPage) {
            ++pageSize;
        }
        if (!src.ensureRemaining(input, pageSize)) {
            throw new BinaryParsingException("Missing remaining bnux page body");
        }
        if (this.isCompressed) {
            this.decompress(src);
        }
        if ((symbolTableSize = src.getInt()) < 0) {
            throw new BinaryParsingException("Negative symbol table size");
        }
        int decodedSize = src.getInt();
        if (decodedSize < 0) {
            throw new BinaryParsingException("Negative decodedSize");
        }
        int encodedSize = src.getInt();
        if (encodedSize < 0) {
            throw new BinaryParsingException("Negative encodedSize");
        }
        this.symbols = null;
        this.symbols = decodedSize == encodedSize ? src.getASCIIStrings(symbolTableSize) : src.getUTF8Strings(symbolTableSize);
        int magic = src.getInt();
        if (magic != BNUX_MAGIC) {
            throw new BinaryParsingException("Bnux magic number mismatch: " + magic + ", must be: " + BNUX_MAGIC);
        }
        if (this.nameCache == null) {
            this.nameCache = new String[Math.min(64, symbolTableSize)];
        } else {
            i = this.nameCache.length;
            while (--i >= 0) {
                this.nameCache[i] = null;
            }
        }
        if (this.factory.getClass() == NodeFactory.class) {
            if (this.textCache == null) {
                this.textCache = new Text[Math.min(256, symbolTableSize)];
            } else {
                i = this.textCache.length;
                while (--i >= 0) {
                    this.textCache[i] = null;
                }
            }
        }
    }

    private void decompress(ArrayByteList src) throws BinaryParsingException {
        if (this.nodeTokens == null) {
            this.nodeTokens = new ArrayByteList();
        }
        this.nodeTokens.clear();
        try {
            this.nodeTokens.add(this.decompressor, src);
        }
        catch (DataFormatException e) {
            String s = e.getMessage();
            throw new BinaryParsingException(s != null ? s : "Invalid ZLIB data format", e);
        }
        src.swap(this.nodeTokens);
        this.nodeTokens.clear();
    }

    private Document readDocument(ArrayByteList src, InputStream input) throws BinaryParsingException, IOException {
        this.readPage(src, input);
        Document doc = this.factory.startMakingDocument();
        doc.setBaseURI(this.getInternedName(src.getInt()));
        boolean hasRootElement = false;
        int i = 0;
        while (src.remaining() > 0) {
            Nodes nodes;
            byte type = src.get();
            switch (type & 7) {
                case 0: {
                    throw new BinaryParsingException("Unreachable text");
                }
                case 1: {
                    throw new BinaryParsingException("Unreachable attribute");
                }
                case 2: {
                    if (this.factory.getClass() == NodeFactory.class) {
                        Element root = this.readStartTag(src, type);
                        this.readElement(src, root, input);
                        nodes = new Nodes((Node)root);
                        break;
                    }
                    Element root = this.readStartTagF(src, type, true);
                    if (root == null) {
                        throw new NullPointerException("Factory failed to create root element.");
                    }
                    doc.setRootElement(root);
                    this.readElementF(src, root, input);
                    nodes = this.factory.finishMakingElement(root);
                    break;
                }
                case 3: {
                    throw new BinaryParsingException("Unreachable end of element");
                }
                case 4: {
                    nodes = this.readCommentF(src, type);
                    break;
                }
                case 5: {
                    throw new BinaryParsingException("Unreachable namespace declaration");
                }
                case 6: {
                    nodes = this.readProcessingInstructionF(src);
                    break;
                }
                case 7: {
                    nodes = this.readDocTypeF(src);
                    break;
                }
                default: {
                    throw new BinaryParsingException("Illegal node type code=" + type);
                }
            }
            for (int j = 0; j < nodes.size(); ++j) {
                Node node = nodes.get(j);
                if (node instanceof Element) {
                    if (hasRootElement) {
                        throw new IllegalAddException("Factory returned multiple root elements");
                    }
                    doc.setRootElement((Element)node);
                    hasRootElement = true;
                } else {
                    doc.insertChild(node, i);
                }
                ++i;
            }
        }
        if (!hasRootElement) {
            throw new WellformednessException("Factory attempted to remove the root element");
        }
        this.factory.finishMakingDocument(doc);
        return doc;
    }

    private Element readStartTag(ArrayByteList src, int type) {
        String qname = this.readString(src, 4, type);
        String namespaceURI = this.readName(src, 6, type);
        return this.nodeBuilder.createElement(qname, namespaceURI);
    }

    private Element readStartTagF(ArrayByteList src, int type, boolean isRoot) {
        String qname = this.readString(src, 4, type);
        String namespaceURI = this.readName(src, 6, type);
        return isRoot ? this.factory.makeRootElement(qname, namespaceURI) : this.factory.startMakingElement(qname, namespaceURI);
    }

    private void readElement(ArrayByteList src, Element current, InputStream input) throws BinaryParsingException, IOException {
        block10: while (true) {
            ProcessingInstruction node = null;
            Element down = null;
            byte type = src.get();
            switch (type & 7) {
                case 0: {
                    node = this.readText(src, type);
                    break;
                }
                case 1: {
                    this.readAttribute(src, current, type);
                    continue block10;
                }
                case 2: {
                    down = this.readStartTag(src, type);
                    node = down;
                    break;
                }
                case 3: {
                    if ((current = (Element)current.getParent()) != null) continue block10;
                    return;
                }
                case 4: {
                    node = this.readComment(src, type);
                    break;
                }
                case 5: {
                    this.readNamespaceDeclaration(src, current, type);
                    continue block10;
                }
                case 6: {
                    node = this.readProcessingInstruction(src);
                    break;
                }
                case 7: {
                    this.readPage(src, input);
                    continue block10;
                }
            }
            current.insertChild((Node)node, current.getChildCount());
            if (down == null) continue;
            current = down;
        }
    }

    private void readElementF(ArrayByteList src, Element current, InputStream input) throws BinaryParsingException, IOException {
        FastStack stack = new FastStack();
        stack.push(current);
        boolean addAttributesAndNamespaces = true;
        block10: while (true) {
            Nodes nodes = null;
            byte type = src.get();
            switch (type & 7) {
                case 0: {
                    nodes = this.readTextF(src, type);
                    break;
                }
                case 1: {
                    Element elem = addAttributesAndNamespaces ? current : null;
                    nodes = this.readAttributeF(src, elem, type);
                    break;
                }
                case 2: {
                    Element elem = this.readStartTagF(src, type, false);
                    stack.push(elem);
                    if (elem != null) {
                        current.insertChild((Node)elem, current.getChildCount());
                        current = elem;
                    }
                    addAttributesAndNamespaces = elem != null;
                    continue block10;
                }
                case 3: {
                    Element elem = stack.pop();
                    if (elem == null) continue block10;
                    ParentNode parent = elem.getParent();
                    if (parent == null) {
                        BinaryXMLCodec.throwTamperedWithParent();
                    }
                    if (parent instanceof Document) {
                        return;
                    }
                    current = (Element)parent;
                    nodes = this.factory.finishMakingElement(elem);
                    if (nodes.size() == 1 && nodes.get(0) == elem) continue block10;
                    if (current.getChildCount() - 1 < 0) {
                        BinaryXMLCodec.throwTamperedWithParent();
                    }
                    current.removeChild(current.getChildCount() - 1);
                    break;
                }
                case 4: {
                    nodes = this.readCommentF(src, type);
                    break;
                }
                case 5: {
                    Element elem = addAttributesAndNamespaces ? current : null;
                    this.readNamespaceDeclaration(src, elem, type);
                    continue block10;
                }
                case 6: {
                    nodes = this.readProcessingInstructionF(src);
                    break;
                }
                case 7: {
                    this.readPage(src, input);
                    continue block10;
                }
            }
            BinaryXMLCodec.appendNodes(current, nodes);
        }
    }

    private static void appendNodes(Element elem, Nodes nodes) {
        if (nodes != null) {
            int size = nodes.size();
            for (int i = 0; i < size; ++i) {
                Node node = nodes.get(i);
                if (node instanceof Attribute) {
                    elem.addAttribute((Attribute)node);
                    continue;
                }
                elem.insertChild(node, elem.getChildCount());
            }
        }
    }

    private static void throwTamperedWithParent() {
        throw new XMLException("Factory has tampered with a parent pointer of ancestor-or-self in finishMakingElement()");
    }

    private void readAttribute(ArrayByteList src, Element dst, int type) throws BinaryParsingException {
        String qname = this.readString(src, 4, type);
        String namespaceURI = this.readName(src, 6, type);
        String value = this.readString(src, 4, src.get());
        Attribute.Type attrType = Util.getAttributeType(src.get());
        Attribute attr = this.nodeBuilder.createAttribute(qname, namespaceURI, value, attrType);
        dst.addAttribute(attr);
    }

    private Nodes readAttributeF(ArrayByteList src, Element dst, int type) throws BinaryParsingException {
        String qname = this.readString(src, 4, type);
        String namespaceURI = this.readName(src, 6, type);
        String value = this.readString(src, 4, src.get());
        Attribute.Type attrType = Util.getAttributeType(src.get());
        if (dst == null) {
            return null;
        }
        return this.factory.makeAttribute(qname, namespaceURI, value, attrType);
    }

    private Comment readComment(ArrayByteList src, int type) {
        return new Comment(this.readString(src, 4, type));
    }

    private Nodes readCommentF(ArrayByteList src, int type) {
        return this.factory.makeComment(this.readString(src, 4, type));
    }

    private void readNamespaceDeclaration(ArrayByteList src, Element dst, int type) {
        String prefix = this.readString(src, 4, type);
        String uri = this.readName(src, 6, type);
        if (dst != null) {
            dst.addNamespaceDeclaration(prefix, uri);
        }
    }

    private ProcessingInstruction readProcessingInstruction(ArrayByteList src) {
        byte type = src.get(src.position() - 1);
        String target = this.readString(src, 4, type);
        String value = this.readString(src, 6, type);
        return new ProcessingInstruction(target, value);
    }

    private Nodes readProcessingInstructionF(ArrayByteList src) {
        byte type = src.get(src.position() - 1);
        String target = this.readString(src, 4, type);
        String value = this.readString(src, 6, type);
        return this.factory.makeProcessingInstruction(target, value);
    }

    private Nodes readDocTypeF(ArrayByteList src) {
        String internalDTDSubset;
        String systemID;
        String rootElementName = this.symbols[src.getInt()];
        String publicID = this.symbols[src.getInt()];
        if (DOCTYPE_NULL_ID.equals(publicID)) {
            publicID = null;
        }
        if (DOCTYPE_NULL_ID.equals(systemID = this.symbols[src.getInt()])) {
            systemID = null;
        }
        if ((internalDTDSubset = this.symbols[src.getInt()]).length() == 0) {
            internalDTDSubset = null;
        }
        Nodes nodes = this.factory.makeDocType(rootElementName, publicID, systemID);
        for (int i = 0; i < nodes.size(); ++i) {
            DocType docType;
            if (!(nodes.get(i) instanceof DocType) || (docType = (DocType)nodes.get(i)).getInternalDTDSubset().length() != 0) continue;
            try {
                docType.setInternalDTDSubset(internalDTDSubset);
                continue;
            }
            catch (IllegalAccessError illegalAccessError) {
                // empty catch block
            }
        }
        return nodes;
    }

    private Text readText(ArrayByteList src, int type) {
        Text text;
        int i = BinaryXMLCodec.readSymbol(src, 4, type);
        if (i < this.textCache.length && (text = this.textCache[i]) != null) {
            return new Text(text);
        }
        text = new Text(this.symbols[i]);
        if (i < this.textCache.length) {
            this.textCache[i] = text;
        }
        return text;
    }

    private Nodes readTextF(ArrayByteList src, int type) {
        return this.factory.makeText(this.readString(src, 4, type));
    }

    private String readString(ArrayByteList src, int shift, int type) {
        int i = BinaryXMLCodec.readSymbol(src, shift, type);
        if (i < 0) {
            return "";
        }
        return this.symbols[i];
    }

    private static int readSymbol(ArrayByteList src, int shift, int type) {
        if (Util.isInlinedIndex(type)) {
            if (shift == 6) {
                return -1;
            }
            return Util.getInlinedIndex(type);
        }
        switch (type >>> shift & 3) {
            case 0: {
                return Util.getUnsignedByte(src.get());
            }
            case 1: {
                return Util.getUnsignedShort(src.getShort());
            }
            case 2: {
                return -1;
            }
        }
        return src.getInt();
    }

    private String readName(ArrayByteList src, int shift, int type) {
        int i = BinaryXMLCodec.readSymbol(src, shift, type);
        if (i < 0) {
            return "";
        }
        if (i < this.nameCache.length) {
            String name = this.nameCache[i];
            if (name == null) {
                this.nameCache[i] = name = this.getInternedName(i);
            }
            return name;
        }
        return this.symbols[i];
    }

    private String getInternedName(int i) {
        String name = this.symbols[i];
        if (name.length() == 0) {
            name = "";
        } else if ((name = (String)this.internedNames.get(name)) == null) {
            name = this.symbols[i];
            this.internedNames.put(name, name);
        }
        return name;
    }

    private void writePage(boolean isLastPage) throws IOException {
        int pageSize;
        Entry[] entries = this.symbolTable.getEntries();
        int numChars = this.symbolTable.numCharacters();
        this.packSort(entries, this.indexData);
        this.page.ensureCapacity(this.page.size() + 1 + 4 + 4 + 4 + 4 + 4 + numChars * 4 + entries.length + this.nodeTokens.size() + this.indexData.size() + numChars / 100);
        this.page.add((byte)7);
        this.page.addInt(0);
        int pageOffset = this.page.size();
        this.page.addInt(entries.length);
        this.page.addInt(numChars + entries.length);
        this.page.addInt(0);
        int encodedOffset = this.page.size();
        this.encodeSymbols(entries, this.page);
        int encodedSize = this.page.size() - encodedOffset;
        this.page.setInt(encodedOffset - 4, encodedSize);
        entries = null;
        this.page.addInt(BNUX_MAGIC);
        this.encodeTokens(this.nodeTokens, this.indexData.asArray(), this.page);
        this.nodeTokens.clear();
        if (this.compressionLevel > 0) {
            this.page.position(pageOffset);
            this.nodeTokens.add(this.compressor, this.page);
            this.page.remove(pageOffset, this.page.size());
            pageSize = this.nodeTokens.size();
        } else {
            pageSize = this.page.size() - pageOffset;
        }
        if (isLastPage) {
            pageSize = -pageSize;
        }
        this.page.setInt(pageOffset - 4, pageSize);
        this.page.write(this.out);
        this.nodeTokens.write(this.out);
        if (!isLastPage) {
            this.symbolTable.clear();
        }
        this.page.clear();
        this.nodeTokens.clear();
        this.indexData.clear();
    }

    private void writeDocument(Document doc) throws IOException {
        this.writeXMLDeclaration(doc.getBaseURI());
        for (int i = 0; i < doc.getChildCount(); ++i) {
            Node node = doc.getChild(i);
            if (node instanceof Element) {
                this.writeElement((Element)node);
                continue;
            }
            if (node instanceof Comment) {
                this.writeComment((Comment)node);
                continue;
            }
            if (node instanceof ProcessingInstruction) {
                this.writeProcessingInstruction((ProcessingInstruction)node);
                continue;
            }
            if (node instanceof DocType) {
                this.writeDocType((DocType)node);
                continue;
            }
            throw new IllegalAddException("Cannot write node type: " + node);
        }
        this.writeEndDocument();
    }

    final void writeXMLDeclaration(String baseURI) {
        if (baseURI == null) {
            baseURI = "";
        }
        this.symbolTable = new SymbolTable();
        if (this.nodeTokens == null) {
            this.nodeTokens = new ArrayByteList();
        }
        this.nodeTokens.clear();
        if (this.indexData == null) {
            this.indexData = new ArrayIntList();
        }
        this.indexData.clear();
        if (this.page == null) {
            this.page = new ArrayByteList(256);
        }
        this.page.clear();
        this.page.ensureCapacity(26);
        this.page.addInt(BNUX_MAGIC);
        int version = 7;
        if (this.compressionLevel > 0) {
            version = -version;
        }
        this.page.add((byte)version);
        this.isFirstPage = true;
        this.writeIndex(baseURI);
    }

    final void writeEndDocument() throws IOException {
        this.flush(true);
    }

    final void flush(boolean isLastPage) throws IOException {
        try {
            if (this.nodeTokens.size() > 0) {
                this.writePage(isLastPage);
            }
            this.out.flush();
        }
        finally {
            if (isLastPage) {
                this.symbolTable = null;
                this.out = null;
            }
            this.nodeTokens.clear();
        }
    }

    private void writeChild(Node node) throws IOException {
        if (node instanceof Element) {
            this.writeElement((Element)node);
        } else if (node instanceof Text) {
            this.writeText((Text)node);
        } else if (node instanceof Comment) {
            this.writeComment((Comment)node);
        } else if (node instanceof ProcessingInstruction) {
            this.writeProcessingInstruction((ProcessingInstruction)node);
        } else {
            throw new IllegalAddException("Cannot write node type: " + node);
        }
    }

    final void writeElement(Element elem) throws IOException {
        this.writeStartTag(elem);
        for (int i = 0; i < elem.getChildCount(); ++i) {
            this.writeChild(elem.getChild(i));
        }
        this.writeEndTag();
    }

    final void writeStartTag(Element elem) {
        this.writeIndex(elem.getNamespacePrefix(), elem.getLocalName());
        int type = 2;
        if (elem.getNamespaceURI().length() == 0) {
            type = Util.noNamespace(type);
        } else {
            this.writeIndex(elem.getNamespaceURI());
        }
        this.nodeTokens.add((byte)type);
        for (int i = 0; i < elem.getAttributeCount(); ++i) {
            this.writeAttribute(elem.getAttribute(i));
        }
        this.writeNamespaceDeclarations(elem);
    }

    final void writeEndTag() throws IOException {
        if (this.nodeTokens.size() + this.indexData.size() + this.symbolTable.numCharacters() + this.symbolTable.size() >= 65536) {
            this.writePage(false);
        }
        this.nodeTokens.add((byte)3);
    }

    private void writeAttribute(Attribute attr) {
        this.writeIndex(attr.getNamespacePrefix(), attr.getLocalName());
        int type = 1;
        if (attr.getNamespaceURI().length() == 0) {
            type = Util.noNamespace(type);
        } else {
            this.writeIndex(attr.getNamespaceURI());
        }
        this.writeIndex(attr.getValue());
        this.nodeTokens.add((byte)type);
        this.nodeTokens.add(Util.getAttributeTypeCode(attr));
    }

    final void writeComment(Comment comment) {
        this.nodeTokens.add((byte)4);
        this.writeIndex(comment.getValue());
    }

    final void writeDocType(DocType docType) {
        this.nodeTokens.add((byte)7);
        this.writeIndex(docType.getRootElementName());
        this.writeIndex(docType.getPublicID() == null ? DOCTYPE_NULL_ID : docType.getPublicID());
        this.writeIndex(docType.getSystemID() == null ? DOCTYPE_NULL_ID : docType.getSystemID());
        this.writeIndex(docType.getInternalDTDSubset() == null ? "" : docType.getInternalDTDSubset());
    }

    private void writeNamespaceDeclarations(Element elem) {
        int count = elem.getNamespaceDeclarationCount();
        if (count == 1) {
            return;
        }
        for (int i = 0; i < count; ++i) {
            String prefix = elem.getNamespacePrefix(i);
            String uri = elem.getNamespaceURI(prefix);
            if (prefix.equals(elem.getNamespacePrefix()) && uri.equals(elem.getNamespaceURI())) continue;
            this.nodeTokens.add((byte)5);
            this.writeIndex(prefix);
            this.writeIndex(uri);
        }
    }

    final void writeProcessingInstruction(ProcessingInstruction pi) {
        this.nodeTokens.add((byte)6);
        this.writeIndex(pi.getTarget());
        this.writeIndex(pi.getValue());
    }

    final void writeText(Text text) {
        this.nodeTokens.add((byte)0);
        this.writeIndex(text.getValue());
    }

    private final void writeIndex(String symbol) {
        this.writeIndex("", symbol);
    }

    private final void writeIndex(String prefix, String localName) {
        int index = this.symbolTable.addSymbol(prefix, localName);
        this.indexData.add(index);
    }

    private void encodeSymbols(Entry[] entries, ArrayByteList dst) {
        for (Entry entry : entries) {
            dst.addUTF8String(entry.getKey1(), entry.getKey2());
        }
    }

    private void packSort(Entry[] entries, ArrayIntList indexData) {
        if (entries.length <= 256) {
            return;
        }
        int head = entries.length;
        int i = entries.length;
        while (--i >= 0) {
            Entry e = entries[i];
            if (e.getFrequency() != 1) continue;
            entries[i] = entries[--head];
            entries[head] = e;
        }
        Arrays.sort(entries, 0, head, new Comparator(){

            public final int compare(Object e1, Object e2) {
                int f1 = ((Entry)e1).getFrequency();
                int f2 = ((Entry)e2).getFrequency();
                return f2 - f1;
            }
        });
        int[] indexes = new int[entries.length];
        int i2 = entries.length;
        while (--i2 >= 0) {
            indexes[entries[i2].getIndex()] = i2;
        }
        int[] ix = indexData.asArray();
        int i3 = indexData.size();
        while (--i3 >= 0) {
            ix[i3] = indexes[ix[i3]];
        }
    }

    private void encodeTokens(ArrayByteList tokenList, int[] indexes, ArrayByteList dst) {
        byte[] tokens = tokenList.asArray();
        int size = tokenList.size();
        int i = 0;
        int j = 0;
        if (this.isFirstPage) {
            dst.addInt(indexes[i++]);
        }
        this.isFirstPage = false;
        block10: while (j < size) {
            byte type = tokens[j++];
            dst.add(type);
            switch (type & 7) {
                case 0: {
                    Util.packOneIndex(dst, indexes[i++], type);
                    continue block10;
                }
                case 1: {
                    if (Util.hasNoNamespace(type)) {
                        Util.packOneIndex(dst, indexes[i++], type);
                    } else {
                        Util.packTwoIndexes(dst, indexes[i++], indexes[i++], type);
                    }
                    dst.add((byte)0);
                    Util.packOneIndex(dst, indexes[i++], 0);
                    dst.add(tokens[j++]);
                    continue block10;
                }
                case 2: {
                    if (Util.hasNoNamespace(type)) {
                        Util.packOneIndex(dst, indexes[i++], type);
                        continue block10;
                    }
                    Util.packTwoIndexes(dst, indexes[i++], indexes[i++], type);
                    continue block10;
                }
                case 3: {
                    continue block10;
                }
                case 4: {
                    Util.packOneIndex(dst, indexes[i++], type);
                    continue block10;
                }
                case 5: {
                    Util.packTwoIndexes(dst, indexes[i++], indexes[i++], type);
                    continue block10;
                }
                case 6: {
                    Util.packTwoIndexes(dst, indexes[i++], indexes[i++], type);
                    continue block10;
                }
                case 7: {
                    dst.addInt(indexes[i++]);
                    dst.addInt(indexes[i++]);
                    dst.addInt(indexes[i++]);
                    dst.addInt(indexes[i++]);
                    continue block10;
                }
            }
            throw new IllegalArgumentException("illegal node type");
        }
    }

    private static int createMagicNumber() {
        ArrayByteList magic = new ArrayByteList(4);
        magic.add((byte)-32);
        magic.add((byte)1);
        magic.add((byte)-33);
        magic.add((byte)-2);
        return magic.getInt();
    }

    private static String toString(int type) {
        switch (type & 7) {
            case 0: {
                return "TEXT";
            }
            case 1: {
                return "ATTRIBUTE";
            }
            case 2: {
                return "BEGIN_ELEMENT";
            }
            case 3: {
                return "END_ELEMENT";
            }
            case 4: {
                return "COMMENT";
            }
            case 5: {
                return "NAMESPACE_DECLARATION";
            }
            case 6: {
                return "PROCESSING_INSTRUCTION";
            }
            case 7: {
                return "DOC_TYPE";
            }
        }
        throw new IllegalArgumentException("Illegal node type code=" + (type & 7));
    }

    private static String toString(Entry[] entries) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < entries.length; ++i) {
            list.add(entries[i].getQualifiedName());
        }
        return list.toString();
    }

    private static final class FastStack {
        private Element[] elements = new Element[10];
        private int size = 0;

        private FastStack() {
        }

        public Element pop() {
            Element elem = this.elements[this.size - 1];
            this.elements[--this.size] = null;
            return elem;
        }

        public void push(Element elem) {
            if (this.size == this.elements.length) {
                this.ensureCapacity(this.size + 1);
            }
            this.elements[this.size++] = elem;
        }

        private void ensureCapacity(int minCapacity) {
            if (minCapacity > this.elements.length) {
                int newCapacity = Math.max(minCapacity, 2 * this.elements.length + 1);
                this.elements = this.subArray(0, this.size, newCapacity);
            }
        }

        private Element[] subArray(int from, int length, int capacity) {
            Element[] subArray = new Element[capacity];
            System.arraycopy(this.elements, from, subArray, 0, length);
            return subArray;
        }
    }

    private static final class Entry {
        String key1;
        String key2;
        final int hash;
        final int index;
        int frequency = 1;
        Entry next;

        public Entry(String key1, String key2, int hash, Entry next, int index) {
            this.key1 = key1;
            this.key2 = key2;
            this.hash = hash;
            this.next = next;
            this.index = index;
        }

        public String getKey1() {
            return this.key1;
        }

        public String getKey2() {
            return this.key2;
        }

        public int getIndex() {
            return this.index;
        }

        public int getFrequency() {
            return this.frequency;
        }

        public String getQualifiedName() {
            if (this.key1.length() == 0) {
                return this.key2;
            }
            return this.key1 + ':' + this.key2;
        }

        public String toString() {
            return "[key1=" + this.key1 + ", key2=" + this.key2 + ", freq=" + this.frequency + "]";
        }
    }

    private static final class SymbolTable {
        private static final float LOAD_FACTOR = 0.75f;
        private static final int INITIAL_CAPACITY = 16;
        private Entry[] entries = new Entry[16];
        private int threshold = 12;
        private int size = 0;
        private int numChars = 0;

        public void clear() {
            this.size = 0;
            this.numChars = 0;
            Entry[] src = this.entries;
            int i = src.length;
            while (--i >= 0) {
                src[i] = null;
            }
        }

        public int numCharacters() {
            return this.numChars;
        }

        public int size() {
            return this.size;
        }

        public int addSymbol(String key1, String key2) {
            int hash = SymbolTable.hash(key1, key2);
            int i = hash & this.entries.length - 1;
            Entry entry = SymbolTable.findEntry(key1, key2, this.entries[i], hash);
            if (entry != null) {
                ++entry.frequency;
                return entry.index;
            }
            this.numChars += key1.length() + key2.length();
            if (key1.length() != 0) {
                ++this.numChars;
            }
            this.entries[i] = new Entry(key1, key2, hash, this.entries[i], this.size);
            if (this.size >= this.threshold) {
                this.rehash();
            }
            return this.size++;
        }

        private static Entry findEntry(String key1, String key2, Entry cursor, int hash) {
            while (cursor != null) {
                if (hash == cursor.hash && SymbolTable.eq(key2, cursor.key2) && SymbolTable.eq(key1, cursor.key1)) {
                    cursor.key1 = key1;
                    cursor.key2 = key2;
                    return cursor;
                }
                cursor = cursor.next;
            }
            return null;
        }

        private void rehash() {
            Entry[] src = this.entries;
            int capacity = 2 * src.length;
            Entry[] dst = new Entry[capacity];
            int i = src.length;
            while (--i >= 0) {
                Entry e = src[i];
                while (e != null) {
                    int j = e.hash & capacity - 1;
                    Entry next = e.next;
                    e.next = dst[j];
                    dst[j] = e;
                    e = next;
                }
            }
            this.entries = dst;
            this.threshold = (int)((float)capacity * 0.75f);
        }

        public Entry[] getEntries() {
            Entry[] dst = new Entry[this.size];
            Entry[] src = this.entries;
            int i = src.length;
            while (--i >= 0) {
                Entry e = src[i];
                while (e != null) {
                    dst[e.index] = e;
                    e = e.next;
                }
            }
            return dst;
        }

        private static int hash(String key1, String key2) {
            int h = key2.hashCode();
            if (key1 != "") {
                h = key1.hashCode() ^ h;
            }
            return SymbolTable.auxiliaryHash(h);
        }

        private static int auxiliaryHash(int h) {
            h += ~(h << 9);
            h ^= h >>> 14;
            h += h << 4;
            h ^= h >>> 10;
            return h;
        }

        private static boolean eq(String x, String y) {
            return x == y || x.equals(y);
        }

        private static void checkNULChar(String key) {
            int i = key.indexOf(0);
            if (i >= 0) {
                throw new IllegalArgumentException("Symbol must not contain C0 control character NUL (char 0x00) [index:" + i + " within '" + key + "']");
            }
        }
    }
}

