/*
 * Decompiled with CFR 0.152.
 */
package nux.xom.xquery;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import nu.xom.Attribute;
import nu.xom.Comment;
import nu.xom.DocType;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.Nodes;
import nu.xom.ParentNode;
import nu.xom.ProcessingInstruction;
import nu.xom.Serializer;
import nu.xom.Text;
import nu.xom.XMLException;

public class ResultSequenceSerializer {
    public static final String W3C_ALGORITHM = "w3c";
    public static final String WRAP_ALGORITHM = "wrap";
    private String algorithm = "w3c";
    private int indent = 0;
    private String encoding = "UTF-8";
    private boolean nfc = false;

    public String getAlgorithm() {
        return this.algorithm;
    }

    public int getIndent() {
        return this.indent;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public boolean getUnicodeNormalizationFormC() {
        return this.nfc;
    }

    public void setAlgorithm(String algorithm) {
        if (!W3C_ALGORITHM.equals(algorithm) && !WRAP_ALGORITHM.equals(algorithm)) {
            throw new IllegalArgumentException("Unrecognized XQuery serialization algorithm: " + algorithm);
        }
        this.algorithm = algorithm;
    }

    public void setEncoding(String encoding) {
        if (encoding == null) {
            throw new NullPointerException("Encoding must not be null");
        }
        this.encoding = encoding;
    }

    public void setIndent(int indent) {
        this.indent = indent;
    }

    public void setUnicodeNormalizationFormC(boolean nfc) {
        this.nfc = nfc;
    }

    public String toString() {
        return "[algorithm=" + this.getAlgorithm() + ", encoding=" + this.getEncoding() + ", indent=" + this.getIndent() + ", unicodeNormalizationFormC=" + this.getUnicodeNormalizationFormC() + "]";
    }

    public void write(Nodes nodes, OutputStream out) throws IOException {
        SequenceSerializer ser = W3C_ALGORITHM.equals(this.getAlgorithm()) ? new W3CSerializer(out, this.getEncoding()) : new WrapSerializer(out, this.getEncoding());
        ser.setIndent(this.getIndent());
        ser.setUnicodeNormalizationFormC(this.getUnicodeNormalizationFormC());
        ser.write(nodes);
    }

    static boolean isAtomicValue(Node node) {
        if (node instanceof Element) {
            Element elem = (Element)node;
            return elem.getLocalName().equals("atomic-value") && elem.getNamespaceURI().equals("http://dsd.lbl.gov/nux");
        }
        return false;
    }

    private static final class WrapSerializer
    extends SequenceSerializer {
        private static final HashMap TEMPLATES = WrapSerializer.initTemplates();

        public WrapSerializer(OutputStream out, String encoding) throws UnsupportedEncodingException {
            super(out, encoding);
        }

        @Override
        public void write(Nodes nodes) throws IOException {
            Document doc = WrapSerializer.wrapSequence(nodes);
            this.write(doc);
        }

        private static Document wrapSequence(Nodes nodes) {
            Element items = (Element)TEMPLATES.get(Nodes.class.getName());
            items = new Element(items);
            int size = nodes.size();
            for (int i = 0; i < size; ++i) {
                items.appendChild((Node)WrapSerializer.wrap(nodes.get(i)));
            }
            return new Document(items);
        }

        private static Element wrap(Node node) {
            if (ResultSequenceSerializer.isAtomicValue(node)) {
                return (Element)node.copy();
            }
            Element item = (Element)TEMPLATES.get(node.getClass().getName());
            if (item == null) {
                throw new IllegalArgumentException("Unrecognized node type: " + node.getClass());
            }
            item = new Element(item);
            if (node instanceof Attribute) {
                Attribute attr = (Attribute)node;
                item.addAttribute((Attribute)attr.copy());
            } else if (node instanceof Document) {
                Document doc = (Document)node;
                for (int j = 0; j < doc.getChildCount(); ++j) {
                    item.appendChild(doc.getChild(j).copy());
                }
            } else if (node instanceof DocType) {
                DocType docType = (DocType)node;
                Element e = new Element("rootName");
                e.appendChild(docType.getRootElementName());
                item.appendChild((Node)e);
                if (docType.getPublicID() != null) {
                    e = new Element("publicID");
                    e.appendChild(docType.getPublicID());
                    item.appendChild((Node)e);
                }
                if (docType.getSystemID() != null) {
                    e = new Element("systemID");
                    e.appendChild(docType.getSystemID());
                    item.appendChild((Node)e);
                }
                if (docType.getInternalDTDSubset().length() > 0) {
                    e = new Element("internalDTDSubset");
                    e.appendChild(docType.getInternalDTDSubset());
                    item.appendChild((Node)e);
                }
            } else {
                item.appendChild(node.copy());
            }
            return item;
        }

        private static HashMap initTemplates() {
            HashMap<String, Element> templates = new HashMap<String, Element>();
            String ns = "http://dsd.lbl.gov/nux";
            Element template = new Element("item:document", ns);
            templates.put(Document.class.getName(), template);
            template = new Element("item:element", ns);
            templates.put(Element.class.getName(), template);
            template = new Element("item:attribute", ns);
            templates.put(Attribute.class.getName(), template);
            template = new Element("item:text", ns);
            templates.put(Text.class.getName(), template);
            template = new Element("item:comment", ns);
            templates.put(Comment.class.getName(), template);
            template = new Element("item:pi", ns);
            templates.put(ProcessingInstruction.class.getName(), template);
            template = new Element("item:docType", ns);
            templates.put(DocType.class.getName(), template);
            template = new Element("item:items", ns);
            template.addNamespaceDeclaration("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            templates.put(Nodes.class.getName(), template);
            return templates;
        }
    }

    private static final class W3CSerializer
    extends SequenceSerializer {
        private boolean writeNamespaceDeclarationsInScope = false;

        public W3CSerializer(OutputStream out, String encoding) throws UnsupportedEncodingException {
            super(out, encoding);
        }

        protected void writeXMLDeclaration() throws IOException {
            this.writeRaw("<?xml version=\"1.0\" encoding=\"");
            this.writeRaw(this.getEncoding());
            this.writeRaw("\"?>");
        }

        @Override
        public void write(Nodes nodes) throws IOException {
            boolean indentYes = this.getIndent() > 0;
            boolean mayBreakLine = true;
            boolean isPreviousAtomic = false;
            this.writeNamespaceDeclarationsInScope = false;
            this.writeXMLDeclaration();
            int size = nodes.size();
            for (int i = 0; i < size; ++i) {
                Node node = nodes.get(i);
                if (node instanceof Attribute) {
                    throw new XMLException("SENR0001: W3C XQuery Serialization spec forbids top-level attributes");
                }
                if (node instanceof Document) {
                    Document doc = (Document)node;
                    for (int j = 0; j < doc.getChildCount(); ++j) {
                        Node child = doc.getChild(j);
                        if (mayBreakLine && indentYes && child instanceof Element) {
                            this.breakLine();
                        }
                        this.writeChild(child);
                        mayBreakLine = true;
                    }
                    isPreviousAtomic = false;
                    continue;
                }
                if (ResultSequenceSerializer.isAtomicValue(node)) {
                    if (isPreviousAtomic) {
                        this.writeEscaped(" ");
                    }
                    this.writeEscaped(node.getChild(0).getValue());
                    mayBreakLine = false;
                    isPreviousAtomic = true;
                    continue;
                }
                if (node instanceof Text) {
                    String value = node.getValue();
                    if (value.length() <= 0) continue;
                    this.writeEscaped(value);
                    mayBreakLine = false;
                    isPreviousAtomic = false;
                    continue;
                }
                if (node instanceof Element) {
                    ParentNode parent;
                    if (mayBreakLine && indentYes) {
                        this.breakLine();
                    }
                    this.writeNamespaceDeclarationsInScope = (parent = node.getParent()) != null && !(parent instanceof Document);
                }
                this.writeChild(node);
                this.writeNamespaceDeclarationsInScope = false;
                mayBreakLine = true;
                isPreviousAtomic = false;
            }
            if (mayBreakLine && indentYes) {
                this.breakLine();
            }
            this.flush();
        }

        protected void writeNamespaceDeclarations(Element element) throws IOException {
            if (this.writeNamespaceDeclarationsInScope) {
                this.writeNamespaceDeclarationsInScope = false;
                this.writeNamespaceDeclarationsInScope(element);
            } else {
                super.writeNamespaceDeclarations(element);
            }
        }

        private void writeNamespaceDeclarationsInScope(Element element) throws IOException {
            Map namespaces = W3CSerializer.getNamespacePrefixesInScope(element);
            int size = namespaces.size();
            Iterator iter = namespaces.entrySet().iterator();
            for (int i = 0; i < size; ++i) {
                Map.Entry entry = iter.next();
                String uri = (String)entry.getValue();
                if (uri.length() <= 0) continue;
                String prefix = (String)entry.getKey();
                this.writeRaw(" ");
                this.writeNamespaceDeclaration(prefix, uri);
            }
        }

        private static Map getNamespacePrefixesInScope(Element element) {
            return W3CSerializer.getNamespacePrefixesInScopeNonPublic(element);
        }

        private static Map getNamespacePrefixesInScopeNonPublic(Element element) {
            ParentNode parent;
            HashMap<String, String> namespaces = new HashMap<String, String>();
            do {
                int size = element.getNamespaceDeclarationCount();
                for (int i = 0; i < size; ++i) {
                    String prefix = element.getNamespacePrefix(i);
                    if (namespaces.containsKey(prefix)) continue;
                    String uri = element.getNamespaceURI(prefix);
                    namespaces.put(prefix, uri);
                }
            } while ((element = (parent = element.getParent()) instanceof Element ? (Element)parent : null) != null);
            return namespaces;
        }
    }

    private static abstract class SequenceSerializer
    extends Serializer {
        public SequenceSerializer(OutputStream out, String encoding) throws UnsupportedEncodingException {
            super(out, encoding);
        }

        public abstract void write(Nodes var1) throws IOException;
    }
}

