/*
 * Decompiled with CFR 0.152.
 */
package org.threeten.extra;

import java.time.DateTimeException;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.IsoFields;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalUnit;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public final class Temporals {
    private Temporals() {
    }

    public static TemporalAdjuster nextWorkingDay() {
        return Adjuster.NEXT_WORKING;
    }

    public static TemporalAdjuster previousWorkingDay() {
        return Adjuster.PREVIOUS_WORKING;
    }

    public static ChronoUnit chronoUnit(TimeUnit unit) {
        Objects.requireNonNull(unit, "unit");
        switch (unit) {
            case NANOSECONDS: {
                return ChronoUnit.NANOS;
            }
            case MICROSECONDS: {
                return ChronoUnit.MICROS;
            }
            case MILLISECONDS: {
                return ChronoUnit.MILLIS;
            }
            case SECONDS: {
                return ChronoUnit.SECONDS;
            }
            case MINUTES: {
                return ChronoUnit.MINUTES;
            }
            case HOURS: {
                return ChronoUnit.HOURS;
            }
            case DAYS: {
                return ChronoUnit.DAYS;
            }
        }
        throw new IllegalArgumentException("Unknown TimeUnit constant");
    }

    public static TimeUnit timeUnit(ChronoUnit unit) {
        Objects.requireNonNull(unit, "unit");
        switch (unit) {
            case NANOS: {
                return TimeUnit.NANOSECONDS;
            }
            case MICROS: {
                return TimeUnit.MICROSECONDS;
            }
            case MILLIS: {
                return TimeUnit.MILLISECONDS;
            }
            case SECONDS: {
                return TimeUnit.SECONDS;
            }
            case MINUTES: {
                return TimeUnit.MINUTES;
            }
            case HOURS: {
                return TimeUnit.HOURS;
            }
            case DAYS: {
                return TimeUnit.DAYS;
            }
        }
        throw new IllegalArgumentException("ChronoUnit cannot be converted to TimeUnit: " + unit);
    }

    public static long[] convertAmount(long amount, TemporalUnit fromUnit, TemporalUnit toUnit) {
        int toMonthFactor;
        Objects.requireNonNull(fromUnit, "fromUnit");
        Objects.requireNonNull(toUnit, "toUnit");
        Temporals.validateUnit(fromUnit);
        Temporals.validateUnit(toUnit);
        if (fromUnit.equals(toUnit)) {
            return new long[]{amount, 0L};
        }
        if (Temporals.isPrecise(fromUnit) && Temporals.isPrecise(toUnit)) {
            long toNanos;
            long fromNanos = fromUnit.getDuration().toNanos();
            if (fromNanos > (toNanos = toUnit.getDuration().toNanos())) {
                long multiple = fromNanos / toNanos;
                return new long[]{Math.multiplyExact(amount, multiple), 0L};
            }
            long multiple = toNanos / fromNanos;
            return new long[]{amount / multiple, amount % multiple};
        }
        int fromMonthFactor = Temporals.monthMonthFactor(fromUnit, fromUnit, toUnit);
        if (fromMonthFactor > (toMonthFactor = Temporals.monthMonthFactor(toUnit, fromUnit, toUnit))) {
            long multiple = fromMonthFactor / toMonthFactor;
            return new long[]{Math.multiplyExact(amount, multiple), 0L};
        }
        long multiple = toMonthFactor / fromMonthFactor;
        return new long[]{amount / multiple, amount % multiple};
    }

    private static void validateUnit(TemporalUnit unit) {
        if (unit instanceof ChronoUnit ? unit.equals(ChronoUnit.ERAS) || unit.equals(ChronoUnit.FOREVER) : !unit.equals(IsoFields.QUARTER_YEARS)) {
            throw new UnsupportedTemporalTypeException("Unsupported TemporalUnit: " + unit);
        }
    }

    private static boolean isPrecise(TemporalUnit unit) {
        return unit instanceof ChronoUnit && ((ChronoUnit)unit).compareTo(ChronoUnit.WEEKS) <= 0;
    }

    private static int monthMonthFactor(TemporalUnit unit, TemporalUnit fromUnit, TemporalUnit toUnit) {
        if (unit instanceof ChronoUnit) {
            switch ((ChronoUnit)unit) {
                case MONTHS: {
                    return 1;
                }
                case YEARS: {
                    return 12;
                }
                case DECADES: {
                    return 120;
                }
                case CENTURIES: {
                    return 1200;
                }
                case MILLENNIA: {
                    return 12000;
                }
            }
            throw new DateTimeException(String.format("Unable to convert between units: %s to %s", fromUnit, toUnit));
        }
        return 3;
    }

    private static enum Adjuster implements TemporalAdjuster
    {
        NEXT_WORKING{

            @Override
            public Temporal adjustInto(Temporal temporal) {
                int dow = temporal.get(ChronoField.DAY_OF_WEEK);
                switch (dow) {
                    case 6: {
                        return temporal.plus(2L, ChronoUnit.DAYS);
                    }
                    case 5: {
                        return temporal.plus(3L, ChronoUnit.DAYS);
                    }
                }
                return temporal.plus(1L, ChronoUnit.DAYS);
            }
        }
        ,
        PREVIOUS_WORKING{

            @Override
            public Temporal adjustInto(Temporal temporal) {
                int dow = temporal.get(ChronoField.DAY_OF_WEEK);
                switch (dow) {
                    case 1: {
                        return temporal.minus(3L, ChronoUnit.DAYS);
                    }
                    case 7: {
                        return temporal.minus(2L, ChronoUnit.DAYS);
                    }
                }
                return temporal.minus(1L, ChronoUnit.DAYS);
            }
        };

    }
}

