/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.common.region;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tikv.common.ReadOnlyPDClient;
import org.tikv.common.TiConfiguration;
import org.tikv.common.codec.KeyUtils;
import org.tikv.common.exception.GrpcException;
import org.tikv.common.exception.InvalidStoreException;
import org.tikv.common.exception.TiClientInternalException;
import org.tikv.common.log.SlowLogSpan;
import org.tikv.common.region.RegionCache;
import org.tikv.common.region.StoreHealthyChecker;
import org.tikv.common.region.TiRegion;
import org.tikv.common.region.TiStore;
import org.tikv.common.region.TiStoreType;
import org.tikv.common.util.BackOffer;
import org.tikv.common.util.ChannelFactory;
import org.tikv.common.util.ConcreteBackOffer;
import org.tikv.common.util.HistogramUtils;
import org.tikv.common.util.Pair;
import org.tikv.kvproto.Metapb;
import org.tikv.kvproto.Pdpb;
import org.tikv.shade.com.google.protobuf.ByteString;
import org.tikv.shade.io.prometheus.client.Histogram;

public class RegionManager {
    private static final Logger logger = LoggerFactory.getLogger(RegionManager.class);
    public static final Histogram GET_REGION_BY_KEY_REQUEST_LATENCY = (Histogram)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)HistogramUtils.buildDuration().name("client_java_get_region_by_requests_latency")).help("getRegionByKey request latency.")).labelNames("cluster")).register();
    public static final Histogram SCAN_REGIONS_REQUEST_LATENCY = (Histogram)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)HistogramUtils.buildDuration().name("client_java_scan_regions_request_latency")).help("scanRegions request latency.")).labelNames("cluster")).register();
    private final RegionCache cache = new RegionCache();
    private final ReadOnlyPDClient pdClient;
    private final TiConfiguration conf;
    private final ScheduledExecutorService executor;
    private final StoreHealthyChecker storeChecker;

    public RegionManager(TiConfiguration conf, ReadOnlyPDClient pdClient, ChannelFactory channelFactory) {
        StoreHealthyChecker storeChecker;
        this.pdClient = pdClient;
        this.conf = conf;
        long period = conf.getHealthCheckPeriodDuration();
        this.storeChecker = storeChecker = new StoreHealthyChecker(channelFactory, pdClient, this.cache, conf.getGrpcHealthCheckTimeout());
        this.executor = Executors.newScheduledThreadPool(1);
        this.executor.scheduleAtFixedRate(storeChecker, period, period, TimeUnit.MILLISECONDS);
    }

    public RegionManager(TiConfiguration conf, ReadOnlyPDClient pdClient) {
        this.pdClient = pdClient;
        this.conf = conf;
        this.storeChecker = null;
        this.executor = null;
    }

    public synchronized void close() {
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
    }

    public ReadOnlyPDClient getPDClient() {
        return this.pdClient;
    }

    public void invalidateAll() {
        this.cache.invalidateAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Pdpb.Region> scanRegions(BackOffer backOffer, ByteString startKey, ByteString endKey, int limit) {
        Long clusterId = this.pdClient.getClusterId();
        Histogram.Timer requestTimer = ((Histogram.Child)SCAN_REGIONS_REQUEST_LATENCY.labels(clusterId.toString())).startTimer();
        SlowLogSpan slowLogSpan = backOffer.getSlowLog().start("scanRegions");
        try {
            List<Pdpb.Region> list = this.pdClient.scanRegions(backOffer, startKey, endKey, limit);
            return list;
        }
        catch (Exception e) {
            ArrayList<Pdpb.Region> arrayList = new ArrayList<Pdpb.Region>();
            return arrayList;
        }
        finally {
            requestTimer.observeDuration();
            slowLogSpan.end();
        }
    }

    public TiRegion getRegionByKey(ByteString key) {
        return this.getRegionByKey(key, this.defaultBackOff());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TiRegion getRegionByKey(ByteString key, BackOffer backOffer) {
        Long clusterId = this.pdClient.getClusterId();
        Histogram.Timer requestTimer = ((Histogram.Child)GET_REGION_BY_KEY_REQUEST_LATENCY.labels(clusterId.toString())).startTimer();
        SlowLogSpan slowLogSpan = backOffer.getSlowLog().start("getRegionByKey");
        TiRegion region = this.cache.getRegionByKey(key, backOffer);
        try {
            if (region == null) {
                logger.debug("Key not found in keyToRegionIdCache:" + KeyUtils.formatBytesUTF8(key));
                Pair<Metapb.Region, Metapb.Peer> regionAndLeader = this.pdClient.getRegionByKey(backOffer, key);
                region = this.cache.putRegion(this.createRegion((Metapb.Region)regionAndLeader.first, (Metapb.Peer)regionAndLeader.second, backOffer));
            }
        }
        catch (Exception e) {
            TiRegion tiRegion = null;
            return tiRegion;
        }
        finally {
            requestTimer.observeDuration();
            slowLogSpan.end();
        }
        return region;
    }

    @Deprecated
    public TiRegion getRegionById(long regionId) {
        BackOffer backOffer = this.defaultBackOff();
        TiRegion region = this.cache.getRegionById(regionId);
        if (region == null) {
            Pair<Metapb.Region, Metapb.Peer> regionAndLeader = this.pdClient.getRegionByID(backOffer, regionId);
            region = this.createRegion((Metapb.Region)regionAndLeader.first, (Metapb.Peer)regionAndLeader.second, backOffer);
            return this.cache.putRegion(region);
        }
        return region;
    }

    public Pair<TiRegion, TiStore> getRegionStorePairByKey(ByteString key, BackOffer backOffer) {
        return this.getRegionStorePairByKey(key, TiStoreType.TiKV, backOffer);
    }

    public Pair<TiRegion, TiStore> getRegionStorePairByKey(ByteString key) {
        return this.getRegionStorePairByKey(key, TiStoreType.TiKV);
    }

    public Pair<TiRegion, TiStore> getRegionStorePairByKey(ByteString key, TiStoreType storeType) {
        return this.getRegionStorePairByKey(key, storeType, this.defaultBackOff());
    }

    public Pair<TiRegion, TiStore> getRegionStorePairByKey(ByteString key, TiStoreType storeType, BackOffer backOffer) {
        TiRegion region = this.getRegionByKey(key, backOffer);
        if (!region.isValid()) {
            throw new TiClientInternalException("Region invalid: " + region);
        }
        TiStore store = null;
        if (storeType == TiStoreType.TiKV) {
            Metapb.Peer peer = region.getCurrentReplica();
            store = this.getStoreById(peer.getStoreId(), backOffer);
        } else {
            block0: for (Metapb.Peer peer : region.getLearnerList()) {
                TiStore s = this.getStoreById(peer.getStoreId(), backOffer);
                for (Metapb.StoreLabel label : s.getStore().getLabelsList()) {
                    if (!label.getKey().equals(storeType.getLabelKey()) || !label.getValue().equals(storeType.getLabelValue())) continue;
                    store = s;
                    break block0;
                }
            }
            if (store == null) {
                this.cache.invalidateRegion(region);
            }
        }
        return Pair.create(region, store);
    }

    public TiRegion createRegion(Metapb.Region region, BackOffer backOffer) {
        return this.createRegion(region, null, backOffer);
    }

    private TiRegion createRegion(Metapb.Region region, Metapb.Peer leader, BackOffer backOffer) {
        ArrayList<Metapb.Peer> peers = new ArrayList<Metapb.Peer>();
        ArrayList<TiStore> stores = new ArrayList<TiStore>();
        for (Metapb.Peer peer : region.getPeersList()) {
            try {
                stores.add(this.getStoreById(peer.getStoreId(), backOffer));
                peers.add(peer);
            }
            catch (Exception e) {
                logger.warn("Store {} not found: {}", (Object)peer.getStoreId(), (Object)e.toString());
            }
        }
        Metapb.Region newRegion = Metapb.Region.newBuilder().mergeFrom(region).clearPeers().addAllPeers(peers).build();
        return new TiRegion(this.conf, newRegion, leader, peers, stores);
    }

    private TiStore getStoreByIdWithBackOff(long id, BackOffer backOffer) {
        try {
            TiStore store = this.cache.getStoreById(id);
            if (store != null) {
                return store;
            }
            store = new TiStore(this.pdClient.getStore(backOffer, id));
            if (store.getStore() == null) {
                logger.warn(String.format("failed to get store %d from pd", id));
                return null;
            }
            if (store.getStore().getState().equals(Metapb.StoreState.Tombstone)) {
                logger.warn(String.format("store %d is tombstone", id));
                return null;
            }
            if (this.cache.putStore(id, store) && this.storeChecker != null) {
                this.storeChecker.scheduleStoreHealthCheck(store);
            }
            return store;
        }
        catch (Exception e) {
            throw new GrpcException(e);
        }
    }

    public TiStore getStoreById(long id) {
        return this.getStoreById(id, this.defaultBackOff());
    }

    public TiStore getStoreById(long id, BackOffer backOffer) {
        TiStore store = this.getStoreByIdWithBackOff(id, backOffer);
        if (store == null) {
            logger.warn(String.format("failed to fetch store %d, the store may be missing", id));
            this.cache.clearAll();
            throw new InvalidStoreException(id);
        }
        return store;
    }

    public void onRegionStale(TiRegion region) {
        this.cache.invalidateRegion(region);
    }

    public TiRegion updateLeader(TiRegion region, long storeId) {
        if (region.getLeader().getStoreId() == storeId) {
            return region;
        }
        TiRegion newRegion = region.switchPeer(storeId);
        if (this.cache.updateRegion(region, newRegion)) {
            return newRegion;
        }
        logger.warn("Cannot find peer when updating leader (" + region.getId() + "," + storeId + ")");
        return null;
    }

    public synchronized void updateStore(TiStore oldStore, TiStore newStore) {
        if (this.cache.updateStore(oldStore, newStore) && this.storeChecker != null) {
            this.storeChecker.scheduleStoreHealthCheck(newStore);
        }
    }

    public void clearRegionCache() {
        this.cache.clearAll();
    }

    public synchronized void onRequestFail(TiRegion region) {
        this.cache.invalidateRegion(region);
    }

    public void invalidateStore(long storeId) {
        this.cache.invalidateStore(storeId);
    }

    public void invalidateRegion(TiRegion region) {
        this.cache.invalidateRegion(region);
    }

    public void insertRegionToCache(TiRegion region) {
        this.cache.insertRegionToCache(region);
    }

    private BackOffer defaultBackOff() {
        return ConcreteBackOffer.newCustomBackOff(this.conf.getRawKVDefaultBackoffInMS(), this.pdClient.getClusterId());
    }
}

