/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.impl;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.picketlink.authentication.event.PreAuthenticateEvent;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.PartitionManager;
import org.picketlink.idm.RelationshipManager;
import org.picketlink.idm.credential.Password;
import org.picketlink.idm.model.Account;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Relationship;
import org.picketlink.idm.model.basic.Grant;
import org.picketlink.idm.model.basic.Role;
import org.picketlink.idm.model.basic.User;

@ApplicationScoped
public class PicketLinkDefaultUsers {
    @Inject
    private PartitionManager partitionManager;
    private boolean done = false;

    public synchronized void create(@Observes PreAuthenticateEvent event) {
        if (this.done) {
            return;
        }
        this.done = true;
        IdentityManager identityManager = this.partitionManager.createIdentityManager();
        RelationshipManager relationshipManager = this.partitionManager.createRelationshipManager();
        User admin = new User("admin");
        admin.setEmail("john@doe.com");
        admin.setFirstName("John");
        admin.setLastName("Doe");
        User nonAdmin = new User("joe");
        nonAdmin.setEmail("joe@doe.com");
        nonAdmin.setFirstName("Joe");
        nonAdmin.setLastName("Doe");
        identityManager.add((IdentityType)admin);
        identityManager.add((IdentityType)nonAdmin);
        identityManager.updateCredential((Account)admin, (Object)new Password("admin"));
        identityManager.updateCredential((Account)nonAdmin, (Object)new Password("joe"));
        Role roleSimple = new Role("simple");
        Role roleAdmin = new Role("admin");
        identityManager.add((IdentityType)roleSimple);
        identityManager.add((IdentityType)roleAdmin);
        relationshipManager.add((Relationship)new Grant((IdentityType)admin, roleSimple));
        relationshipManager.add((Relationship)new Grant((IdentityType)admin, roleAdmin));
        relationshipManager.add((Relationship)new Grant((IdentityType)nonAdmin, roleSimple));
    }
}

