/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.workbench.model.impl;

import java.util.HashSet;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.model.PanelDefinition;
import org.uberfire.workbench.model.impl.PanelDefinitionImpl;
import org.uberfire.workbench.model.impl.PartDefinitionImpl;

public class PartDefinitionImplTest {
    private PartDefinitionImpl part;
    private PanelDefinition parent;
    private PanelDefinition anotherParent;

    @Before
    public void setUp() throws Exception {
        PlaceRequest placeRequest = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        this.part = new PartDefinitionImpl(placeRequest);
        this.parent = new PanelDefinitionImpl();
        this.anotherParent = new PanelDefinitionImpl();
    }

    @Test(expected=IllegalStateException.class)
    public void defineParentPanelWithOldParent() throws Exception {
        PanelDefinitionImpl parentMock = this.createParentMock();
        this.part.setParentPanel((PanelDefinition)parentMock);
        this.part.setParentPanel(this.anotherParent);
    }

    @Test(expected=IllegalStateException.class)
    public void defineParentPanelWithOldParentWithoutPart() throws Exception {
        this.parent = this.createParentMock();
        this.part.setParentPanel(this.parent);
        Mockito.when((Object)this.parent.getParts()).thenReturn(new HashSet());
        PanelDefinitionImpl anotherParent = this.createParentMock();
        this.part.setParentPanel((PanelDefinition)anotherParent);
    }

    private PanelDefinitionImpl createParentMock() {
        PanelDefinitionImpl parentMock = (PanelDefinitionImpl)Mockito.mock(PanelDefinitionImpl.class);
        HashSet<PartDefinitionImpl> mockSet = new HashSet<PartDefinitionImpl>();
        mockSet.add(this.part);
        Mockito.when((Object)parentMock.getParts()).thenReturn(mockSet);
        return parentMock;
    }

    @Test
    public void defineParentPanel() throws Exception {
        PanelDefinitionImpl parentMock = this.createParentMock();
        this.part.setParentPanel((PanelDefinition)parentMock);
        Assert.assertEquals((Object)parentMock, (Object)this.part.getParentPanel());
    }
}

