/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.apps.client.home.components;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Widget;
import org.gwtbootstrap3.client.ui.Icon;
import org.gwtbootstrap3.client.ui.Label;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.uberfire.ext.apps.api.Directory;
import org.uberfire.ext.apps.client.home.components.popup.NewDirectoryPopup;
import org.uberfire.ext.apps.client.resources.WebAppResource;
import org.uberfire.ext.apps.client.resources.i18n.CommonConstants;
import org.uberfire.mvp.ParameterizedCommand;

public class TilesApp
extends Composite {
    private static WebAppResource APP_CSS = (WebAppResource)GWT.create(WebAppResource.class);
    private static TilesBinder uiBinder = (TilesBinder)GWT.create(TilesBinder.class);
    @UiField
    Icon icon;
    @UiField
    Label label;
    @UiField
    FlowPanel outerPanel;
    @UiField
    FlowPanel tilePanel;
    @UiField
    FlowPanel deletePanel;
    private NewDirectoryPopup newDirectoryPopup;
    private Icon deleteIcon;

    private TilesApp(TYPE type, ParameterizedCommand<String> clickCommand, Directory currentDirectory) {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.defineTileColor(type);
        this.createIcon(type, CommonConstants.INSTANCE.CreateDir());
        this.displayNoneOnLabel();
        this.addClickPopUpHandler(clickCommand, currentDirectory);
    }

    private TilesApp(String componentName, TYPE type, ParameterizedCommand<String> clickCommand) {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.defineTileColor(type);
        this.createIcon(type, CommonConstants.INSTANCE.GotoComponent());
        this.createLabel(componentName);
        this.addClickCommandHandler(clickCommand, componentName);
    }

    private TilesApp(String dirName, String dirURI, TYPE type, ParameterizedCommand<String> clickCommand, ParameterizedCommand<String> deleteCommand) {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.defineTileColor(type);
        this.createIcon(type, CommonConstants.INSTANCE.OpenDir());
        this.createLabel(dirName);
        this.addClickCommandHandler(clickCommand, dirURI);
        this.createDeleteIcon(deleteCommand, dirURI);
    }

    public static TilesApp createDirTiles(TYPE type, ParameterizedCommand<String> clickCommand, Directory currentDirectory) {
        return new TilesApp(type, clickCommand, currentDirectory);
    }

    public static TilesApp componentTiles(String componentName, TYPE type, ParameterizedCommand<String> clickCommand) {
        return new TilesApp(componentName, type, clickCommand);
    }

    public static TilesApp directoryTiles(String dirName, String dirURI, TYPE type, ParameterizedCommand<String> clickCommand, ParameterizedCommand<String> deleteCommand) {
        return new TilesApp(dirName, dirURI, type, clickCommand, deleteCommand);
    }

    private void createDeleteIcon(final ParameterizedCommand<String> deleteCommand, final String dirURI) {
        this.deleteIcon = new Icon(IconType.REMOVE);
        this.deleteIcon.setTitle(CommonConstants.INSTANCE.DeleteDir());
        this.deleteIcon.addStyleName(APP_CSS.CSS().deleteIcon());
        this.deleteIcon.addStyleName("fa");
        this.deleteIcon.addDomHandler((EventHandler)new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (Window.confirm((String)CommonConstants.INSTANCE.DeleteAppPrompt())) {
                    deleteCommand.execute((Object)dirURI);
                }
            }
        }, ClickEvent.getType());
        this.outerPanel.addDomHandler((EventHandler)new MouseOverHandler(){

            public void onMouseOver(MouseOverEvent event) {
                TilesApp.this.deletePanel.add((Widget)TilesApp.this.deleteIcon);
            }
        }, MouseOverEvent.getType());
        this.outerPanel.addDomHandler((EventHandler)new MouseOutHandler(){

            public void onMouseOut(MouseOutEvent event) {
                TilesApp.this.deletePanel.remove((Widget)TilesApp.this.deleteIcon);
            }
        }, MouseOutEvent.getType());
    }

    private void defineTileColor(TYPE type) {
        this.tilePanel.addStyleName(type.tileColor());
        this.deletePanel.addStyleName(type.tileColor());
    }

    private void displayNoneOnLabel() {
        this.label.getElement().getStyle().setProperty("display", "none");
    }

    private void addClickCommandHandler(final ParameterizedCommand<String> clickCommand, final String parameter) {
        this.tilePanel.addDomHandler((EventHandler)new ClickHandler(){

            public void onClick(ClickEvent event) {
                clickCommand.execute((Object)parameter);
            }
        }, ClickEvent.getType());
    }

    private void addClickPopUpHandler(final ParameterizedCommand<String> clickCommand, final Directory currentDirectory) {
        this.tilePanel.addDomHandler((EventHandler)new ClickHandler(){

            public void onClick(ClickEvent event) {
                TilesApp.this.newDirectoryPopup = new NewDirectoryPopup(currentDirectory);
                TilesApp.this.newDirectoryPopup.show(clickCommand);
            }
        }, ClickEvent.getType());
    }

    private void createLabel(String name) {
        this.label.setText(name);
    }

    private void createIcon(TYPE type, String tooltip) {
        this.icon.setTitle(tooltip);
        this.icon.setType(type.icon());
    }

    static /* synthetic */ WebAppResource access$200() {
        return APP_CSS;
    }

    static interface TilesBinder
    extends UiBinder<Widget, TilesApp> {
    }

    public static enum TYPE {
        DIR(IconType.FOLDER_OPEN, TilesApp.access$200().CSS().blueTile()),
        ADD(IconType.PLUS, TilesApp.access$200().CSS().redTile()),
        COMPONENT(IconType.FILE, TilesApp.access$200().CSS().greenTile());

        private IconType iconType;
        private String tile;

        private TYPE(IconType iconType, String tile) {
            this.iconType = iconType;
            this.tile = tile;
        }

        IconType icon() {
            return this.iconType;
        }

        String tileColor() {
            return this.tile;
        }
    }
}

