/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.vfs;

import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.fest.assertions.api.Assertions;
import org.junit.Test;
import org.uberfire.backend.vfs.FileSystem;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.PathFactory;

public class PathTest {
    final FileSystem fs = new FileSystem(){

        public List<Path> getRootDirectories() {
            return null;
        }

        public Set<String> supportedFileAttributeViews() {
            return null;
        }
    };

    @Test
    public void generalState() {
        Path path = PathFactory.newPath((String)"resource", (String)"scheme://path/to/some/resource");
        Assertions.assertThat((boolean)path.equals(path)).isTrue();
        Assertions.assertThat((boolean)path.equals(PathFactory.newPath((String)"resource", (String)"scheme://path/to/some/resource"))).isTrue();
        Assertions.assertThat((int)path.hashCode()).isEqualTo(PathFactory.newPath((String)"resource", (String)"scheme://path/to/some/resource").hashCode());
        Assertions.assertThat((int)path.hashCode()).isEqualTo(path.hashCode());
        path = PathFactory.newPath((String)"resource", (String)"scheme://different/path/to/some/resource");
        Assertions.assertThat((boolean)path.equals(PathFactory.newPath((String)"resource", (String)"scheme://path/to/some/resource"))).isFalse();
        Assertions.assertThat((int)path.hashCode()).isNotEqualTo(PathFactory.newPath((String)"resource", (String)"scheme://path/to/some/resource").hashCode());
        path = PathFactory.newPath((String)"resource", (String)"scheme://different/path/to/some/resource");
        Assertions.assertThat((boolean)path.equals("something")).isFalse();
        Assertions.assertThat((boolean)path.equals(null)).isFalse();
    }

    @Test
    public void checkNPE() {
        HashMap<Path, String> hashMap = new HashMap<Path, String>();
        Path path = PathFactory.newPath((String)"defaultPackage", (String)"default://guvnor-jcr2vfs-migration/defaultPackage/");
        hashMap.put(path, "content");
        Assertions.assertThat((String)((String)hashMap.get(path))).isEqualTo((Object)"content");
        Assertions.assertThat((String)((String)hashMap.get(PathFactory.newPath((String)"defaultPackage", (String)"default://guvnor-jcr2vfs-migration/defaultPackage/")))).isEqualTo((Object)"content");
    }
}

