/*
 * Decompiled with CFR 0.152.
 */
package org.appformer.maven.support;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.appformer.maven.support.DependencyFilter;
import org.appformer.maven.support.MinimalPomParser;
import org.appformer.maven.support.PomModelGenerator;
import org.appformer.maven.support.ReleaseId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface PomModel {
    public static final String NATIVE_MAVEN_PARSER_CLASS = "org.appformer.maven.integration.MavenPomModelGenerator";

    public ReleaseId getReleaseId();

    public ReleaseId getParentReleaseId();

    public Collection<ReleaseId> getDependencies();

    public Collection<ReleaseId> getDependencies(DependencyFilter var1);

    public static class DefaultPomModelGenerator
    implements PomModelGenerator {
        @Override
        public PomModel parse(String path, InputStream is) {
            return MinimalPomParser.parse(path, is);
        }
    }

    public static class Parser {
        private static final Logger log = LoggerFactory.getLogger(PomModel.class);

        public static PomModel parse(String path, InputStream is) {
            try {
                return PomModelGeneratorHolder.pomModelGenerator.parse(path, is);
            }
            catch (Exception e) {
                if (PomModelGeneratorHolder.pomModelGenerator.getClass().getName().equals(PomModel.NATIVE_MAVEN_PARSER_CLASS) && Parser.isOpen(is)) {
                    log.warn("Error generated by the maven pom parser, falling back to the internal one", (Throwable)e);
                    return MinimalPomParser.parse(path, is);
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
        }

        private static boolean isOpen(InputStream is) {
            try {
                return is.available() > 0;
            }
            catch (IOException ioe) {
                return false;
            }
        }

        private static class PomModelGeneratorHolder {
            private static PomModelGenerator pomModelGenerator;

            private PomModelGeneratorHolder() {
            }

            static {
                try {
                    pomModelGenerator = (PomModelGenerator)Class.forName(PomModel.NATIVE_MAVEN_PARSER_CLASS).newInstance();
                }
                catch (Exception e) {
                    pomModelGenerator = new DefaultPomModelGenerator();
                }
            }
        }
    }

    public static class InternalModel
    implements PomModel {
        private ReleaseId releaseId;
        private ReleaseId parentReleaseId;
        private final Map<String, Set<ReleaseId>> dependencies = new HashMap<String, Set<ReleaseId>>();

        @Override
        public ReleaseId getReleaseId() {
            return this.releaseId;
        }

        public void setReleaseId(ReleaseId releaseId) {
            this.releaseId = releaseId;
        }

        @Override
        public ReleaseId getParentReleaseId() {
            return this.parentReleaseId;
        }

        public void setParentReleaseId(ReleaseId parentReleaseId) {
            this.parentReleaseId = parentReleaseId;
        }

        @Override
        public Collection<ReleaseId> getDependencies() {
            return this.getDependencies(DependencyFilter.TAKE_ALL_FILTER);
        }

        @Override
        public Collection<ReleaseId> getDependencies(DependencyFilter filter) {
            HashSet<ReleaseId> depSet = new HashSet<ReleaseId>();
            for (Map.Entry<String, Set<ReleaseId>> entry : this.dependencies.entrySet()) {
                for (ReleaseId releaseId : entry.getValue()) {
                    if (!filter.accept(releaseId, entry.getKey())) continue;
                    depSet.add(releaseId);
                }
            }
            return depSet;
        }

        protected void addDependency(ReleaseId dependency, String scope) {
            Set<ReleaseId> depsByScope = this.dependencies.get(scope);
            if (depsByScope == null) {
                depsByScope = new HashSet<ReleaseId>();
                this.dependencies.put(scope, depsByScope);
            }
            depsByScope.add(dependency);
        }
    }
}

