/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata.backend.infinispan.provider;

import org.assertj.core.api.Assertions;
import org.infinispan.client.hotrod.configuration.SaslQop;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.ext.metadata.backend.infinispan.exceptions.InfinispanException;
import org.uberfire.ext.metadata.backend.infinispan.provider.InfinispanContext;

public class InfinispanContextTest {
    private Logger logger = LoggerFactory.getLogger(InfinispanContextTest.class);

    @Test
    public void testToSaslQoP() {
        SaslQop sqsl = InfinispanContext.toSaslQop((String)"auth");
        Assert.assertEquals((Object)sqsl, (Object)SaslQop.AUTH);
        sqsl = InfinispanContext.toSaslQop((String)"auth-int");
        Assert.assertEquals((Object)sqsl, (Object)SaslQop.AUTH_INT);
        sqsl = InfinispanContext.toSaslQop((String)"auth-conf");
        Assert.assertEquals((Object)sqsl, (Object)SaslQop.AUTH_CONF);
    }

    @Test
    public void testWrongToSaslQoP() {
        try {
            SaslQop sqsl = InfinispanContext.toSaslQop((String)"auths");
            Assert.assertEquals((Object)sqsl, (Object)SaslQop.AUTH);
            Assert.fail((String)"auths is an invalid option");
        }
        catch (InfinispanException e) {
            this.logger.info(e.getMessage());
        }
    }

    @Test
    public void testBiuildSaslQop() {
        Object[] sasl = InfinispanContext.buildSaslQop((String)"auth");
        Assertions.assertThat((Object[])sasl).extracting(SaslQop::toString).contains((Object[])new String[]{"auth"});
        sasl = InfinispanContext.buildSaslQop((String)"   AUTH  , auth-int,");
        Assertions.assertThat((Object[])sasl).extracting(SaslQop::toString).contains((Object[])new String[]{"auth", "auth-int"});
        try {
            sasl = InfinispanContext.buildSaslQop((String)"auths");
            Assert.fail((String)"auths is an invalid option");
        }
        catch (InfinispanException e) {
            this.logger.info(e.getMessage());
        }
    }
}

