/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata.backend.infinispan.provider;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.ext.metadata.backend.infinispan.proto.schema.Field;
import org.uberfire.ext.metadata.backend.infinispan.proto.schema.Message;
import org.uberfire.ext.metadata.backend.infinispan.proto.schema.ProtobufScope;
import org.uberfire.ext.metadata.backend.infinispan.proto.schema.ProtobufType;
import org.uberfire.ext.metadata.backend.infinispan.provider.InfinispanContext;
import org.uberfire.ext.metadata.backend.infinispan.provider.InfinispanSchemaStore;
import org.uberfire.ext.metadata.backend.infinispan.provider.MappingProvider;

@RunWith(value=MockitoJUnitRunner.class)
public class InfinispanSchemaStoreTest {
    @Mock
    private InfinispanContext infinispanContext;
    private InfinispanSchemaStore infinispanSchemaStore;
    @Mock
    private MappingProvider mappingProvider;

    @Before
    public void setUp() {
        this.infinispanSchemaStore = new InfinispanSchemaStore(this.infinispanContext, this.mappingProvider);
    }

    @Test
    public void testMerge() {
        String oldFieldName = "oldField";
        String newFieldName = "newField";
        Message oldMessage = new Message();
        Field oldField = new Field(ProtobufScope.OPTIONAL, ProtobufType.STRING, oldFieldName, 1);
        oldMessage.setFields(Collections.singleton(oldField));
        Message newMessage = new Message();
        Field newField = new Field(ProtobufScope.OPTIONAL, ProtobufType.STRING, newFieldName, 2);
        newMessage.setFields(new HashSet<Field>(Arrays.asList(oldField, newField)));
        Message mergedMessage = this.infinispanSchemaStore.merge(oldMessage, newMessage);
        Assertions.assertThat((int)mergedMessage.getFields().size()).isEqualTo(2);
        Assertions.assertThat((Iterable)mergedMessage.getFields()).anySatisfy(field -> field.getName().equals(oldFieldName));
        Assertions.assertThat((Iterable)mergedMessage.getFields()).anySatisfy(field -> field.getName().equals(newFieldName));
    }

    @Test
    public void testMaxIndexNumbert() {
        List<Field> fields = Arrays.asList(new Field(ProtobufScope.OPTIONAL, ProtobufType.STRING, "field1", 1), new Field(ProtobufScope.OPTIONAL, ProtobufType.STRING, "field2", 2));
        int max = this.infinispanSchemaStore.getMaxIndexNumber(fields);
        Assertions.assertThat((int)max).isEqualTo(2);
    }
}

