/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.metadata.io;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.commons.lock.LockService;
import org.uberfire.commons.validation.Preconditions;
import org.uberfire.io.FileSystemType;
import org.uberfire.io.IOService;
import org.uberfire.io.IOWatchService;
import org.uberfire.io.impl.IOServiceDotFileImpl;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.base.FSPath;
import org.uberfire.java.nio.base.WatchContext;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.DirectoryNotEmptyException;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.FileSystemAlreadyExistsException;
import org.uberfire.java.nio.file.FileSystemNotFoundException;
import org.uberfire.java.nio.file.NoSuchFileException;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.ProviderNotFoundException;
import org.uberfire.java.nio.file.StandardWatchEventKind;
import org.uberfire.java.nio.file.WatchEvent;
import org.uberfire.java.nio.file.WatchKey;
import org.uberfire.java.nio.file.WatchService;
import org.uberfire.java.nio.file.attribute.FileAttribute;
import org.uberfire.java.nio.file.attribute.FileAttributeView;
import org.uberfire.metadata.engine.MetaIndexEngine;
import org.uberfire.metadata.io.BatchIndex;
import org.uberfire.metadata.io.KObjectUtil;
import org.uberfire.metadata.model.KCluster;

public class IOServiceIndexedImpl
extends IOServiceDotFileImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(IOServiceIndexedImpl.class);
    private final MetaIndexEngine indexEngine;
    private final BatchIndex batchIndex;
    private final Class<? extends FileAttributeView>[] views;
    private final ThreadGroup threadGroup = new ThreadGroup("IOServiceIndexing");
    private final List<FileSystem> watchedList = new ArrayList<FileSystem>();

    public IOServiceIndexedImpl(MetaIndexEngine indexEngine, Class<? extends FileAttributeView> ... views) {
        this.indexEngine = (MetaIndexEngine)Preconditions.checkNotNull((String)"indexEngine", (Object)indexEngine);
        this.batchIndex = new BatchIndex(indexEngine, (IOService)this, views);
        this.views = views;
    }

    public IOServiceIndexedImpl(String id, MetaIndexEngine indexEngine, Class<? extends FileAttributeView> ... views) {
        super(id);
        this.indexEngine = (MetaIndexEngine)Preconditions.checkNotNull((String)"indexEngine", (Object)indexEngine);
        this.batchIndex = new BatchIndex(indexEngine, (IOService)this, views);
        this.views = views;
    }

    public IOServiceIndexedImpl(IOWatchService watchService, MetaIndexEngine indexEngine, Class<? extends FileAttributeView> ... views) {
        super(watchService);
        this.indexEngine = (MetaIndexEngine)Preconditions.checkNotNull((String)"indexEngine", (Object)indexEngine);
        this.batchIndex = new BatchIndex(indexEngine, (IOService)this, views);
        this.views = views;
    }

    public IOServiceIndexedImpl(String id, IOWatchService watchService, MetaIndexEngine indexEngine, Class<? extends FileAttributeView> ... views) {
        super(id, watchService);
        this.indexEngine = (MetaIndexEngine)Preconditions.checkNotNull((String)"indexEngine", (Object)indexEngine);
        this.batchIndex = new BatchIndex(indexEngine, (IOService)this, views);
        this.views = views;
    }

    public IOServiceIndexedImpl(LockService lockService, IOWatchService watchService, MetaIndexEngine indexEngine, Class<? extends FileAttributeView> ... views) {
        super(lockService, watchService);
        this.indexEngine = (MetaIndexEngine)Preconditions.checkNotNull((String)"indexEngine", (Object)indexEngine);
        this.batchIndex = new BatchIndex(indexEngine, (IOService)this, views);
        this.views = views;
    }

    public IOServiceIndexedImpl(String id, LockService lockService, IOWatchService watchService, MetaIndexEngine indexEngine, Class<? extends FileAttributeView> ... views) {
        super(id, lockService, watchService);
        this.indexEngine = (MetaIndexEngine)Preconditions.checkNotNull((String)"indexEngine", (Object)indexEngine);
        this.batchIndex = new BatchIndex(indexEngine, (IOService)this, views);
        this.views = views;
    }

    public FileSystem getFileSystem(URI uri) throws IllegalArgumentException, FileSystemNotFoundException, ProviderNotFoundException, SecurityException {
        try {
            FileSystem fs = super.getFileSystem(uri);
            this.indexIfFresh(fs);
            this.setupWatchService(fs);
            return fs;
        }
        catch (IllegalArgumentException ex) {
            throw ex;
        }
        catch (FileSystemNotFoundException ex) {
            throw ex;
        }
        catch (ProviderNotFoundException ex) {
            throw ex;
        }
        catch (SecurityException ex) {
            throw ex;
        }
    }

    public FileSystem newFileSystem(URI uri, Map<String, ?> env, FileSystemType type) throws IllegalArgumentException, FileSystemAlreadyExistsException, ProviderNotFoundException, IOException, SecurityException {
        try {
            FileSystem fs = super.newFileSystem(uri, env, type);
            this.index(fs);
            this.setupWatchService(fs);
            return fs;
        }
        catch (IllegalArgumentException ex) {
            throw ex;
        }
        catch (FileSystemAlreadyExistsException ex) {
            throw ex;
        }
        catch (ProviderNotFoundException ex) {
            throw ex;
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (SecurityException ex) {
            throw ex;
        }
    }

    private void setupWatchService(FileSystem fs) {
        if (this.watchedList.contains(fs)) {
            return;
        }
        this.watchedList.add(fs);
        final WatchService ws = fs.newWatchService();
        new Thread(this.threadGroup, "IOServiceIndexedImpl(" + ws.toString() + ")"){

            @Override
            public void run() {
                while (!IOServiceIndexedImpl.this.isDisposed && !ws.isClose()) {
                    WatchKey wk = ws.take();
                    if (wk == null) continue;
                    List events = wk.pollEvents();
                    for (WatchEvent object : events) {
                        try {
                            Path path;
                            WatchContext context = (WatchContext)object.context();
                            if (!(object.kind() != StandardWatchEventKind.ENTRY_MODIFY && object.kind() != StandardWatchEventKind.ENTRY_CREATE || (path = context.getPath()).getFileName().toString().startsWith("."))) {
                                for (Class view : IOServiceIndexedImpl.this.views) {
                                    IOServiceIndexedImpl.this.getFileAttributeView(path, view);
                                }
                                FileAttribute[] allAttrs = IOServiceIndexedImpl.this.convert(IOServiceIndexedImpl.this.readAttributes(path));
                                IOServiceIndexedImpl.this.indexEngine.index(KObjectUtil.toKObject(path, allAttrs));
                            }
                            if (object.kind() == StandardWatchEventKind.ENTRY_RENAME) {
                                IOServiceIndexedImpl.this.indexEngine.rename(KObjectUtil.toKObjectKey(context.getOldPath()), KObjectUtil.toKObject(context.getPath(), new FileAttribute[0]));
                            }
                            if (object.kind() != StandardWatchEventKind.ENTRY_DELETE) continue;
                            IOServiceIndexedImpl.this.indexEngine.delete(KObjectUtil.toKObjectKey(context.getOldPath()));
                        }
                        catch (Exception ex) {
                            LOGGER.error("Error during indexing. { " + object.toString() + " }", (Throwable)ex);
                        }
                    }
                }
                ws.close();
            }
        }.start();
    }

    private void indexIfFresh(FileSystem fs) {
        if (this.indexEngine.freshIndex(KObjectUtil.toKCluster(fs))) {
            this.index(fs);
        }
    }

    private void index(FileSystem fs) {
        this.batchIndex.runAsync(fs);
    }

    public synchronized void delete(Path path, DeleteOption ... options) throws IllegalArgumentException, NoSuchFileException, DirectoryNotEmptyException, IOException, SecurityException {
        KCluster cluster = KObjectUtil.toKCluster(path.getFileSystem());
        super.delete(path, options);
        if (path instanceof FSPath) {
            this.indexEngine.delete(cluster);
        }
    }

    public synchronized boolean deleteIfExists(Path path, DeleteOption ... options) throws IllegalArgumentException, DirectoryNotEmptyException, IOException, SecurityException {
        KCluster cluster = KObjectUtil.toKCluster(path.getFileSystem());
        boolean result = super.deleteIfExists(path, options);
        if (result && path instanceof FSPath) {
            this.indexEngine.delete(cluster);
        }
        return result;
    }
}

