/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata.io;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import org.apache.commons.io.FileUtils;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopScoreDocCollector;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.uberfire.ext.metadata.backend.lucene.LuceneConfig;
import org.uberfire.ext.metadata.backend.lucene.LuceneConfigBuilder;
import org.uberfire.ext.metadata.backend.lucene.index.LuceneIndex;
import org.uberfire.ext.metadata.engine.Index;
import org.uberfire.ext.metadata.io.IOServiceIndexedImpl;
import org.uberfire.ext.metadata.io.KObjectUtil;
import org.uberfire.io.IOService;
import org.uberfire.io.attribute.DublinCoreView;
import org.uberfire.java.nio.base.version.VersionAttributeView;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.attribute.FileAttribute;

public class IOServiceIndexedGitImplTest {
    protected IOService ioService = null;
    private static LuceneConfig config;
    private static boolean created;
    protected final Date dateValue = new Date();
    protected static final List<File> tempFiles;

    public IOService ioService() {
        if (this.ioService == null) {
            config = new LuceneConfigBuilder().withInMemoryMetaModelStore().useDirectoryBasedIndex().useInMemoryDirectory().build();
            this.ioService = new IOServiceIndexedImpl(config.getIndexEngine(), new Class[]{DublinCoreView.class, VersionAttributeView.class});
        }
        return this.ioService;
    }

    @Test
    public void testIndexedFile() throws IOException, InterruptedException {
        Path newOtherPath = this.getDirectoryPath().resolveSibling("someNewOtherPath");
        this.ioService().write(newOtherPath.resolve("dummy"), "<none>", new OpenOption[0]);
        Path path = newOtherPath.resolve("myIndexedFile.txt");
        this.ioService().write(path, "ooooo!", Collections.emptySet(), new FileAttribute[]{new FileAttribute<Object>(){

            public String name() {
                return "custom";
            }

            public Object value() {
                return IOServiceIndexedGitImplTest.this.dateValue;
            }
        }, new FileAttribute<String>(){

            public String name() {
                return "int.hello";
            }

            public String value() {
                return "hello some world jhere";
            }
        }, new FileAttribute<Integer>(){

            public String name() {
                return "int";
            }

            public Integer value() {
                return 10;
            }
        }});
        this.ioService().write(newOtherPath.resolve("myOtherIndexedFile.txt"), "ooooo!", Collections.emptySet(), new FileAttribute[]{new FileAttribute<String>(){

            public String name() {
                return "int.hello";
            }

            public String value() {
                return "jhere";
            }
        }});
        Thread.sleep(5000L);
        Assert.assertNotNull((Object)config.getMetaModelStore().getMetaObject(Path.class.getName()));
        Assert.assertNotNull((Object)config.getMetaModelStore().getMetaObject(Path.class.getName()).getProperty("int"));
        Assert.assertNotNull((Object)config.getMetaModelStore().getMetaObject(Path.class.getName()).getProperty("int.hello"));
        Assert.assertNotNull((Object)config.getMetaModelStore().getMetaObject(Path.class.getName()).getProperty("custom"));
        Assert.assertNotNull((Object)config.getMetaModelStore().getMetaObject(Path.class.getName()).getProperty("int"));
        Assert.assertNotNull((Object)config.getMetaModelStore().getMetaObject(Path.class.getName()).getProperty("int.hello"));
        Assert.assertNotNull((Object)config.getMetaModelStore().getMetaObject(Path.class.getName()).getProperty("custom"));
        Assert.assertEquals((long)1L, (long)config.getMetaModelStore().getMetaObject(Path.class.getName()).getProperty("int").getTypes().size());
        Assert.assertEquals((long)1L, (long)config.getMetaModelStore().getMetaObject(Path.class.getName()).getProperty("int.hello").getTypes().size());
        Assert.assertEquals((long)1L, (long)config.getMetaModelStore().getMetaObject(Path.class.getName()).getProperty("custom").getTypes().size());
        Assert.assertTrue((boolean)config.getMetaModelStore().getMetaObject(Path.class.getName()).getProperty("int").getTypes().contains(Integer.class));
        Assert.assertTrue((boolean)config.getMetaModelStore().getMetaObject(Path.class.getName()).getProperty("int.hello").getTypes().contains(String.class));
        Assert.assertTrue((boolean)config.getMetaModelStore().getMetaObject(Path.class.getName()).getProperty("custom").getTypes().contains(Date.class));
        Index index = config.getIndexManager().get(KObjectUtil.toKCluster((FileSystem)newOtherPath.getFileSystem()));
        IndexSearcher searcher = ((LuceneIndex)index).nrtSearcher();
        TopScoreDocCollector collector = TopScoreDocCollector.create((int)10, (boolean)true);
        searcher.search((Query)new TermQuery(new Term("int.hello", "world")), (Collector)collector);
        ScoreDoc[] hits = collector.topDocs().scoreDocs;
        Assert.assertEquals((long)1L, (long)hits.length);
        collector = TopScoreDocCollector.create((int)10, (boolean)true);
        searcher.search((Query)new TermQuery(new Term("int.hello", "jhere")), (Collector)collector);
        hits = collector.topDocs().scoreDocs;
        Assert.assertEquals((long)2L, (long)hits.length);
        collector = TopScoreDocCollector.create((int)10, (boolean)true);
        searcher.search((Query)new MatchAllDocsQuery(), (Collector)collector);
        hits = collector.topDocs().scoreDocs;
        Assert.assertEquals((long)2L, (long)hits.length);
        ((LuceneIndex)index).nrtRelease(searcher);
    }

    public Path getDirectoryPath() {
        Path dir = this.ioService().get(URI.create("git://indexed-repo-test/_someDir" + new Random(10L).nextInt()));
        this.ioService().deleteIfExists(dir, new DeleteOption[0]);
        return dir;
    }

    private Path getRootPath() {
        return this.ioService().get(URI.create("git://indexed-repo-test/"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Before
    public void setup() throws IOException {
        if (!created) {
            String path = IOServiceIndexedGitImplTest.createTempDirectory().getAbsolutePath();
            System.setProperty("org.uberfire.nio.git.dir", path);
            System.out.println(".niogit: " + path);
            URI newRepo = URI.create("git://indexed-repo-test");
            try {
                this.ioService().newFileSystem(newRepo, new HashMap());
            }
            catch (Exception exception) {
            }
            finally {
                created = true;
            }
        }
    }

    @AfterClass
    @BeforeClass
    public static void cleanup() {
        for (File tempFile : tempFiles) {
            FileUtils.deleteQuietly((File)tempFile);
        }
    }

    public static File createTempDirectory() throws IOException {
        File temp = File.createTempFile("temp", Long.toString(System.nanoTime()));
        if (!temp.delete()) {
            throw new IOException("Could not delete temp file: " + temp.getAbsolutePath());
        }
        if (!temp.mkdir()) {
            throw new IOException("Could not create temp directory: " + temp.getAbsolutePath());
        }
        tempFiles.add(temp);
        return temp;
    }

    static {
        created = false;
        tempFiles = new ArrayList<File>();
    }
}

