/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata.io;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.commons.io.FileUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.uberfire.ext.metadata.backend.lucene.LuceneConfig;
import org.uberfire.ext.metadata.backend.lucene.LuceneConfigBuilder;
import org.uberfire.ext.metadata.io.IOServiceIndexedImpl;
import org.uberfire.ext.metadata.search.ClusterSegment;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.base.FileSystemId;
import org.uberfire.java.nio.base.SegmentedPath;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;

public class LuceneSearchIndexTest {
    private int seed = new Random(10L).nextInt();
    protected boolean created = false;
    private Map<String, Path> basePaths = new HashMap<String, Path>();
    private LuceneConfig config;
    private IOService ioService = null;
    protected static final List<File> tempFiles = new ArrayList<File>();

    @AfterClass
    @BeforeClass
    public static void cleanup() {
        for (File tempFile : tempFiles) {
            FileUtils.deleteQuietly((File)tempFile);
        }
    }

    protected IOService ioService() {
        if (this.ioService == null) {
            this.config = new LuceneConfigBuilder().withInMemoryMetaModelStore().useDirectoryBasedIndex().useInMemoryDirectory().build();
            this.ioService = new IOServiceIndexedImpl(this.config.getIndexEngine(), new Class[0]);
        }
        return this.ioService;
    }

    protected static File createTempDirectory() throws IOException {
        File temp = File.createTempFile("temp", Long.toString(System.nanoTime()));
        if (!temp.delete()) {
            throw new IOException("Could not delete temp file: " + temp.getAbsolutePath());
        }
        if (!temp.mkdir()) {
            throw new IOException("Could not create temp directory: " + temp.getAbsolutePath());
        }
        tempFiles.add(temp);
        return temp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Before
    public void setup() throws IOException {
        if (!this.created) {
            String path = LuceneSearchIndexTest.createTempDirectory().getAbsolutePath();
            System.setProperty("org.uberfire.nio.git.dir", path);
            System.out.println(".niogit: " + path);
            for (String repositoryName : this.getRepositoryNames()) {
                URI newRepo = URI.create("git://" + repositoryName);
                try {
                    this.ioService().newFileSystem(newRepo, new HashMap());
                    Path basePath = this.getDirectoryPath(repositoryName).resolveSibling("someNewOtherPath");
                    this.ioService().write(basePath.resolve("dummy"), "<none>", new OpenOption[0]);
                    this.basePaths.put(repositoryName, basePath);
                }
                catch (Exception ex) {
                    ex.fillInStackTrace();
                    System.out.println(ex.getMessage());
                }
                finally {
                    this.created = true;
                }
            }
        }
    }

    private String[] getRepositoryNames() {
        return new String[]{this.getClass().getSimpleName() + "_1", this.getClass().getSimpleName() + "_2"};
    }

    private Path getBasePath(String repositoryName) {
        return this.basePaths.get(repositoryName);
    }

    private Path getDirectoryPath(String repositoryName) {
        Path dir = this.ioService().get(URI.create("git://" + repositoryName + "/_someDir" + this.seed));
        this.ioService().deleteIfExists(dir, new DeleteOption[0]);
        return dir;
    }

    @Test
    public void testClusterSegments() throws IOException, InterruptedException {
        Path path1 = this.getBasePath(this.getClass().getSimpleName() + "_1").resolve("indexedFile1.txt");
        this.ioService().write(path1, "content1", new OpenOption[0]);
        Path path2 = this.getBasePath(this.getClass().getSimpleName() + "_2").resolve("indexedFile2.txt");
        this.ioService().write(path2, "content2", new OpenOption[0]);
        ClusterSegment cs1 = new ClusterSegment(){

            public String getClusterId() {
                return ((FileSystemId)LuceneSearchIndexTest.this.getBasePath(LuceneSearchIndexTest.this.getClass().getSimpleName() + "_1").getFileSystem()).id();
            }

            public String[] segmentIds() {
                return new String[]{((SegmentedPath)LuceneSearchIndexTest.this.getBasePath(LuceneSearchIndexTest.this.getClass().getSimpleName() + "_1")).getSegmentId()};
            }
        };
        ClusterSegment cs2 = new ClusterSegment(){

            public String getClusterId() {
                return ((FileSystemId)LuceneSearchIndexTest.this.getBasePath(LuceneSearchIndexTest.this.getClass().getSimpleName() + "_2").getFileSystem()).id();
            }

            public String[] segmentIds() {
                return new String[]{((SegmentedPath)LuceneSearchIndexTest.this.getBasePath(LuceneSearchIndexTest.this.getClass().getSimpleName() + "_2")).getSegmentId()};
            }
        };
        Thread.sleep(5000L);
        HashMap<String, Object> attributes = new HashMap<String, Object>(){
            {
                this.put("filename", "*.txt");
            }
        };
        int hits = this.config.getSearchIndex().searchByAttrsHits((Map)attributes, new ClusterSegment[0]);
        Assert.assertEquals((long)2L, (long)hits);
        hits = this.config.getSearchIndex().searchByAttrsHits((Map)attributes, new ClusterSegment[]{cs1});
        Assert.assertEquals((long)1L, (long)hits);
        hits = this.config.getSearchIndex().searchByAttrsHits((Map)attributes, new ClusterSegment[]{cs2});
        Assert.assertEquals((long)1L, (long)hits);
        hits = this.config.getSearchIndex().searchByAttrsHits((Map)attributes, new ClusterSegment[]{cs1, cs2});
        Assert.assertEquals((long)2L, (long)hits);
    }
}

