/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata.io;

import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopScoreDocCollector;
import org.junit.Assert;
import org.junit.Test;
import org.uberfire.ext.metadata.backend.lucene.LuceneConfigBuilder;
import org.uberfire.ext.metadata.backend.lucene.index.LuceneIndex;
import org.uberfire.ext.metadata.engine.Index;
import org.uberfire.ext.metadata.engine.Observer;
import org.uberfire.ext.metadata.io.BaseIndexTest;
import org.uberfire.ext.metadata.io.BatchIndex;
import org.uberfire.ext.metadata.io.KObjectUtil;
import org.uberfire.io.IOService;
import org.uberfire.io.attribute.DublinCoreView;
import org.uberfire.io.impl.IOServiceDotFileImpl;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.attribute.FileAttribute;

public class BatchIndexTest
extends BaseIndexTest {
    public static Observer observer() {
        return new Observer(){

            public void information(String message) {
            }

            public void warning(String message) {
            }

            public void error(String message) {
            }
        };
    }

    @Override
    protected IOService ioService() {
        if (this.ioService == null) {
            this.config = new LuceneConfigBuilder().withInMemoryMetaModelStore().useDirectoryBasedIndex().useInMemoryDirectory().build();
            this.ioService = new IOServiceDotFileImpl();
        }
        return this.ioService;
    }

    @Override
    protected String[] getRepositoryNames() {
        return new String[]{"temp-repo-test"};
    }

    @Test
    public void testIndex() throws IOException, InterruptedException {
        Path file = this.ioService().get("git://temp-repo-test/path/to/file.txt", new String[0]);
        this.ioService().write(file, "some content here", Collections.emptySet(), new FileAttribute[]{new FileAttribute<Object>(){

            public String name() {
                return "dcore.author";
            }

            public Object value() {
                return "My User Name Here";
            }
        }, new FileAttribute<Object>(){

            public String name() {
                return "dcore.lastModification";
            }

            public Object value() {
                return new Date();
            }
        }, new FileAttribute<Object>(){

            public String name() {
                return "dcore.comment";
            }

            public Object value() {
                return "initial document version, should be revised later.";
            }
        }});
        file = this.ioService().get("git://temp-repo-test/path/to/some/complex/file.txt", new String[0]);
        this.ioService().write(file, "some other content here", Collections.emptySet(), new FileAttribute[]{new FileAttribute<Object>(){

            public String name() {
                return "dcore.author";
            }

            public Object value() {
                return "My Second User Name";
            }
        }, new FileAttribute<Object>(){

            public String name() {
                return "dcore.lastModification";
            }

            public Object value() {
                return new Date();
            }
        }, new FileAttribute<Object>(){

            public String name() {
                return "dcore.comment";
            }

            public Object value() {
                return "important document, should be used right now.";
            }
        }});
        file = this.ioService().get("git://temp-repo-test/simple.doc", new String[0]);
        this.ioService().write(file, "some doc content here", Collections.emptySet(), new FileAttribute[]{new FileAttribute<Object>(){

            public String name() {
                return "dcore.author";
            }

            public Object value() {
                return "My Original User";
            }
        }, new FileAttribute<Object>(){

            public String name() {
                return "dcore.lastModification";
            }

            public Object value() {
                return new Date();
            }
        }, new FileAttribute<Object>(){

            public String name() {
                return "dcore.comment";
            }

            public Object value() {
                return "unlock document updated, should be checked by boss.";
            }
        }});
        file = this.ioService().get("git://temp-repo-test/xxx/simple.xls", new String[0]);
        this.ioService().write(file, "plans!?", new OpenOption[0]);
        new BatchIndex(this.config.getIndexEngine(), this.ioService(), BatchIndexTest.observer(), new Class[]{DublinCoreView.class}).run(this.ioService().get("git://temp-repo-test/", new String[0]), new Runnable(){

            @Override
            public void run() {
                try {
                    Index index = BatchIndexTest.this.config.getIndexManager().get(KObjectUtil.toKCluster((FileSystem)BatchIndexTest.this.ioService().get("git://temp-repo-test/", new String[0]).getFileSystem()));
                    IndexSearcher searcher = ((LuceneIndex)index).nrtSearcher();
                    TopScoreDocCollector collector = TopScoreDocCollector.create((int)10, (boolean)true);
                    searcher.search((Query)new MatchAllDocsQuery(), (Collector)collector);
                    ScoreDoc[] hits = collector.topDocs().scoreDocs;
                    Assert.assertEquals((long)4L, (long)hits.length);
                    collector = TopScoreDocCollector.create((int)10, (boolean)true);
                    searcher.search((Query)new TermQuery(new Term("dcore.author", "name")), (Collector)collector);
                    hits = collector.topDocs().scoreDocs;
                    Assert.assertEquals((long)2L, (long)hits.length);
                    collector = TopScoreDocCollector.create((int)10, (boolean)true);
                    searcher.search((Query)new TermQuery(new Term("dcore.author", "second")), (Collector)collector);
                    hits = collector.topDocs().scoreDocs;
                    Assert.assertEquals((long)1L, (long)hits.length);
                    ((LuceneIndex)index).nrtRelease(searcher);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    Assert.fail();
                }
            }
        });
    }
}

