/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata.io;

import java.io.IOException;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.uberfire.ext.metadata.io.BaseIndexTest;
import org.uberfire.ext.metadata.io.IOSearchIndex;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;

public class IOSearchIndexTest
extends BaseIndexTest {
    @Override
    protected String[] getRepositoryNames() {
        return new String[]{this.getClass().getSimpleName()};
    }

    @Test
    public void testFullTextSearch() throws IOException, InterruptedException {
        IOSearchIndex searchIndex = new IOSearchIndex(this.config.getSearchIndex(), this.ioService());
        Path path1 = this.getBasePath(this.getClass().getSimpleName()).resolve("g.txt");
        this.ioService().write(path1, "ooooo!", new OpenOption[0]);
        Path path2 = this.getBasePath(this.getClass().getSimpleName()).resolve("a.txt");
        this.ioService().write(path2, "ooooo!", new OpenOption[0]);
        Path path3 = this.getBasePath(this.getClass().getSimpleName()).resolve("the.txt");
        this.ioService().write(path3, "ooooo!", new OpenOption[0]);
        Path root = path1.getRoot();
        Thread.sleep(5000L);
        List result = searchIndex.fullTextSearch("g", 10, 0, new Path[]{root});
        Assert.assertEquals((long)1L, (long)result.size());
        result = searchIndex.fullTextSearch("a", 10, 0, new Path[]{root});
        Assert.assertEquals((long)1L, (long)result.size());
        result = searchIndex.fullTextSearch("the", 10, 0, new Path[]{root});
        Assert.assertEquals((long)1L, (long)result.size());
        result = searchIndex.fullTextSearch("", 10, 0, new Path[]{root});
        Assert.assertEquals((long)0L, (long)result.size());
        try {
            searchIndex.fullTextSearch(null, 10, 0, new Path[]{root});
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

