/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata.io;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.uberfire.ext.metadata.backend.lucene.LuceneConfigBuilder;
import org.uberfire.ext.metadata.engine.Observer;
import org.uberfire.ext.metadata.io.BaseIndexTest;
import org.uberfire.ext.metadata.io.IOServiceIndexedImpl;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.attribute.FileAttribute;

public class BatchIndexConcurrenyTest
extends BaseIndexTest {
    private static final String REPO_NAME = "temp-repo-batch-index-test";
    private ConcurrencyObserver observer = new ConcurrencyObserver();

    @Override
    protected IOService ioService() {
        if (this.ioService == null) {
            this.config = new LuceneConfigBuilder().withInMemoryMetaModelStore().useDirectoryBasedIndex().useInMemoryDirectory().build();
            this.ioService = new IOServiceIndexedImpl(this.config.getIndexEngine(), (Observer)this.observer, new Class[0]);
        }
        return this.ioService;
    }

    @Override
    protected String[] getRepositoryNames() {
        return new String[]{REPO_NAME};
    }

    @Override
    @Before
    public void setup() throws IOException {
        super.setup();
        this.ioService.createDirectory(this.getBasePath(REPO_NAME), new FileAttribute[0]);
    }

    @After
    public void tearDown() throws IOException {
        this.ioService().deleteIfExists(this.getBasePath(REPO_NAME), new DeleteOption[0]);
    }

    @Test
    public void testSingleBatchIndexExecution() throws IOException, InterruptedException {
        FileSystem fs1 = this.ioService().getFileSystem(URI.create("git://temp-repo-batch-index-test/file1"));
        Assert.assertNotNull((Object)fs1);
        FileSystem fs2 = this.ioService().getFileSystem(URI.create("git://temp-repo-batch-index-test/file1"));
        Assert.assertNotNull((Object)fs2);
        FileSystem fs3 = this.ioService().getFileSystem(URI.create("git://temp-repo-batch-index-test/file1"));
        Assert.assertNotNull((Object)fs3);
        Thread.sleep(5000L);
        this.assertEvents();
    }

    @Test
    public void testSingleConcurrentBatchIndexExecution() throws IOException, InterruptedException {
        final CountDownLatch startSignal = new CountDownLatch(1);
        for (int i = 0; i < 3; ++i) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    try {
                        startSignal.await();
                        BatchIndexConcurrenyTest.this.ioService().getFileSystem(URI.create("git://temp-repo-batch-index-test/file1"));
                    }
                    catch (InterruptedException e) {
                        Assert.fail((String)e.getMessage());
                    }
                }
            };
            new Thread(r).start();
        }
        startSignal.countDown();
        Thread.sleep(5000L);
        this.assertEvents();
    }

    private void assertEvents() {
        System.out.println(this.observer.getInformationMessages());
        Assert.assertEquals((long)2L, (long)this.observer.getInformationMessages().size());
        Assert.assertEquals((long)0L, (long)this.observer.getWarningMessages().size());
        Assert.assertEquals((long)0L, (long)this.observer.getErrorMessages().size());
        this.assertContains("Starting indexing of git://master@temp-repo-batch-index-test/ ...", this.observer.getInformationMessages());
        this.assertContains("Completed indexing of git://master@temp-repo-batch-index-test/", this.observer.getInformationMessages());
    }

    private void assertContains(String expected, List<String> actual) {
        for (String msg : actual) {
            if (!msg.equals(expected)) continue;
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (String msg : actual) {
            sb.append("'").append(msg).append("'\n");
        }
        Assert.fail((String)("Expected '" + expected + "' was not found in " + sb.toString()));
    }

    private static class ConcurrencyObserver
    implements Observer {
        private List<String> informationMessages = new ArrayList<String>();
        private List<String> warningMessages = new ArrayList<String>();
        private List<String> errorMessages = new ArrayList<String>();

        private ConcurrencyObserver() {
        }

        public void information(String message) {
            this.informationMessages.add(message);
        }

        public void warning(String message) {
            this.warningMessages.add(message);
        }

        public void error(String message) {
            this.errorMessages.add(message);
        }

        public List<String> getInformationMessages() {
            return this.informationMessages;
        }

        public List<String> getWarningMessages() {
            return this.warningMessages;
        }

        public List<String> getErrorMessages() {
            return this.errorMessages;
        }
    }
}

