/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata.io;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.uberfire.ext.metadata.io.BaseIndexTest;
import org.uberfire.ext.metadata.search.ClusterSegment;
import org.uberfire.ext.metadata.search.IOSearchService;
import org.uberfire.java.nio.base.FileSystemId;
import org.uberfire.java.nio.base.SegmentedPath;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;

public class LuceneSearchIndexTest
extends BaseIndexTest {
    @Override
    protected String[] getRepositoryNames() {
        return new String[]{this.getClass().getSimpleName() + "_1", this.getClass().getSimpleName() + "_2"};
    }

    @Test
    public void testClusterSegments() throws IOException, InterruptedException {
        Path path1 = this.getBasePath(this.getClass().getSimpleName() + "_1").resolve("indexedFile1.txt");
        this.ioService().write(path1, "content1", new OpenOption[0]);
        Path path2 = this.getBasePath(this.getClass().getSimpleName() + "_2").resolve("indexedFile2.txt");
        this.ioService().write(path2, "content2", new OpenOption[0]);
        ClusterSegment cs1 = new ClusterSegment(){

            public String getClusterId() {
                return ((FileSystemId)LuceneSearchIndexTest.this.getBasePath(LuceneSearchIndexTest.this.getClass().getSimpleName() + "_1").getFileSystem()).id();
            }

            public String[] segmentIds() {
                return new String[]{((SegmentedPath)LuceneSearchIndexTest.this.getBasePath(LuceneSearchIndexTest.this.getClass().getSimpleName() + "_1")).getSegmentId()};
            }
        };
        ClusterSegment cs2 = new ClusterSegment(){

            public String getClusterId() {
                return ((FileSystemId)LuceneSearchIndexTest.this.getBasePath(LuceneSearchIndexTest.this.getClass().getSimpleName() + "_2").getFileSystem()).id();
            }

            public String[] segmentIds() {
                return new String[]{((SegmentedPath)LuceneSearchIndexTest.this.getBasePath(LuceneSearchIndexTest.this.getClass().getSimpleName() + "_2")).getSegmentId()};
            }
        };
        Thread.sleep(5000L);
        HashMap<String, Object> attributes = new HashMap<String, Object>(){
            {
                this.put("filename", "*.txt");
            }
        };
        int hits = this.config.getSearchIndex().searchByAttrsHits((Map)attributes, new ClusterSegment[0]);
        List results = this.config.getSearchIndex().searchByAttrs((Map)attributes, (IOSearchService.Filter)new IOSearchService.NoOpFilter(), new ClusterSegment[0]);
        Assert.assertEquals((long)0L, (long)hits);
        Assert.assertEquals((long)0L, (long)results.size());
        hits = this.config.getSearchIndex().searchByAttrsHits((Map)attributes, new ClusterSegment[]{cs1});
        results = this.config.getSearchIndex().searchByAttrs((Map)attributes, (IOSearchService.Filter)new IOSearchService.NoOpFilter(), new ClusterSegment[]{cs1});
        Assert.assertEquals((long)1L, (long)hits);
        Assert.assertEquals((long)1L, (long)results.size());
        hits = this.config.getSearchIndex().searchByAttrsHits((Map)attributes, new ClusterSegment[]{cs2});
        results = this.config.getSearchIndex().searchByAttrs((Map)attributes, (IOSearchService.Filter)new IOSearchService.NoOpFilter(), new ClusterSegment[]{cs2});
        Assert.assertEquals((long)1L, (long)hits);
        Assert.assertEquals((long)1L, (long)results.size());
        hits = this.config.getSearchIndex().searchByAttrsHits((Map)attributes, new ClusterSegment[]{cs1, cs2});
        results = this.config.getSearchIndex().searchByAttrs((Map)attributes, (IOSearchService.Filter)new IOSearchService.NoOpFilter(), new ClusterSegment[]{cs1, cs2});
        Assert.assertEquals((long)2L, (long)hits);
        Assert.assertEquals((long)2L, (long)results.size());
        hits = this.config.getSearchIndex().fullTextSearchHits("*indexed*", new ClusterSegment[0]);
        results = this.config.getSearchIndex().fullTextSearch("*indexed*", (IOSearchService.Filter)new IOSearchService.NoOpFilter(), new ClusterSegment[0]);
        Assert.assertEquals((long)0L, (long)hits);
        Assert.assertEquals((long)0L, (long)results.size());
        hits = this.config.getSearchIndex().fullTextSearchHits("*indexed*", new ClusterSegment[]{cs1});
        results = this.config.getSearchIndex().fullTextSearch("*indexed*", (IOSearchService.Filter)new IOSearchService.NoOpFilter(), new ClusterSegment[]{cs1});
        Assert.assertEquals((long)1L, (long)hits);
        Assert.assertEquals((long)1L, (long)results.size());
        hits = this.config.getSearchIndex().fullTextSearchHits("*indexed*", new ClusterSegment[]{cs2});
        results = this.config.getSearchIndex().fullTextSearch("*indexed*", (IOSearchService.Filter)new IOSearchService.NoOpFilter(), new ClusterSegment[]{cs2});
        Assert.assertEquals((long)1L, (long)hits);
        Assert.assertEquals((long)1L, (long)results.size());
        hits = this.config.getSearchIndex().fullTextSearchHits("*indexed*", new ClusterSegment[]{cs1, cs2});
        results = this.config.getSearchIndex().fullTextSearch("*indexed*", (IOSearchService.Filter)new IOSearchService.NoOpFilter(), new ClusterSegment[]{cs1, cs2});
        Assert.assertEquals((long)2L, (long)hits);
        Assert.assertEquals((long)2L, (long)results.size());
    }
}

