/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata.io;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.commons.io.FileUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.ScoreDoc;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.uberfire.ext.metadata.backend.lucene.LuceneConfig;
import org.uberfire.ext.metadata.backend.lucene.LuceneConfigBuilder;
import org.uberfire.ext.metadata.backend.lucene.util.KObjectUtil;
import org.uberfire.ext.metadata.io.IOServiceIndexedImpl;
import org.uberfire.ext.metadata.io.IndexersFactory;
import org.uberfire.ext.metadata.model.KObject;
import org.uberfire.io.IOService;
import org.uberfire.io.attribute.DublinCoreView;
import org.uberfire.java.nio.base.version.VersionAttributeView;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.FileSystemAlreadyExistsException;
import org.uberfire.java.nio.file.Path;

public abstract class BaseIndexTest {
    private int seed = new Random(10L).nextInt();
    protected boolean created = false;
    protected static final Map<String, Path> basePaths = new HashMap<String, Path>();
    protected LuceneConfig config;
    protected IOService ioService = null;
    protected static final List<File> tempFiles = new ArrayList<File>();

    @AfterClass
    @BeforeClass
    public static void cleanup() {
        for (File tempFile : tempFiles) {
            FileUtils.deleteQuietly((File)tempFile);
        }
    }

    protected IOService ioService() {
        if (this.ioService == null) {
            this.config = new LuceneConfigBuilder().withInMemoryMetaModelStore().useDirectoryBasedIndex().useInMemoryDirectory().build();
            this.ioService = new IOServiceIndexedImpl(this.config.getIndexEngine(), new Class[]{DublinCoreView.class, VersionAttributeView.class});
        }
        return this.ioService;
    }

    protected static File createTempDirectory() throws IOException {
        File temp = File.createTempFile("temp", Long.toString(System.nanoTime()));
        if (!temp.delete()) {
            throw new IOException("Could not delete temp file: " + temp.getAbsolutePath());
        }
        if (!temp.mkdir()) {
            throw new IOException("Could not create temp directory: " + temp.getAbsolutePath());
        }
        tempFiles.add(temp);
        return temp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Before
    public void setup() throws IOException {
        IndexersFactory.clear();
        if (!this.created) {
            String path = BaseIndexTest.createTempDirectory().getAbsolutePath();
            System.setProperty("org.uberfire.nio.git.dir", path);
            System.out.println(".niogit: " + path);
            for (String repositoryName : this.getRepositoryNames()) {
                URI newRepo = URI.create("git://" + repositoryName);
                try {
                    this.ioService().newFileSystem(newRepo, new HashMap());
                    Path basePath = this.getDirectoryPath(repositoryName).resolveSibling("root");
                    basePaths.put(repositoryName, basePath);
                }
                catch (FileSystemAlreadyExistsException fileSystemAlreadyExistsException) {
                }
                finally {
                    this.created = true;
                }
            }
        }
    }

    protected abstract String[] getRepositoryNames();

    protected Path getBasePath(String repositoryName) {
        return basePaths.get(repositoryName);
    }

    protected void listHitPaths(IndexSearcher searcher, ScoreDoc[] hits) throws IOException {
        for (int i = 0; i < hits.length; ++i) {
            KObject ko = KObjectUtil.toKObject((Document)searcher.doc(hits[i].doc));
            System.out.println(ko.getKey());
        }
    }

    private Path getDirectoryPath(String repositoryName) {
        Path dir = this.ioService().get(URI.create("git://" + repositoryName + "/_someDir" + this.seed));
        this.ioService().deleteIfExists(dir, new DeleteOption[0]);
        return dir;
    }

    public void setupCountDown(int i) {
    }

    public void waitForCountDown(int timout) {
    }

    public int getStartBatchCount() {
        return 0;
    }
}

