/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata.io;

import java.io.IOException;
import java.net.URI;
import java.util.concurrent.CountDownLatch;
import org.jboss.byteman.contrib.bmunit.BMScript;
import org.jboss.byteman.contrib.bmunit.BMUnitRunner;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.uberfire.ext.metadata.io.BaseIndexTest;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;

@RunWith(value=BMUnitRunner.class)
@BMScript(value="byteman/index.btm")
public class BatchIndexConcurrencyTest
extends BaseIndexTest {
    @Override
    protected String[] getRepositoryNames() {
        return new String[]{this.getClass().getSimpleName()};
    }

    @Test
    public void testSingleConcurrentBatchIndexExecution() throws IOException, InterruptedException {
        Path path1 = this.getBasePath(this.getClass().getSimpleName()).resolve("xxx");
        this.ioService().write(path1, "xxx!", new OpenOption[0]);
        this.setupCountDown(3);
        URI fsURI = URI.create("git://" + this.getClass().getSimpleName() + "/file1");
        CountDownLatch startSignal = new CountDownLatch(1);
        for (int i = 0; i < 3; ++i) {
            Runnable r = () -> {
                try {
                    startSignal.await();
                    this.ioService().getFileSystem(fsURI);
                }
                catch (InterruptedException e) {
                    Assert.fail((String)e.getMessage());
                }
            };
            new Thread(r).start();
        }
        startSignal.countDown();
        this.waitForCountDown(5000);
        Assert.assertEquals((long)1L, (long)this.getStartBatchCount());
    }
}

