/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata.io;

import java.io.IOException;
import java.util.Collections;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopScoreDocCollector;
import org.jboss.byteman.contrib.bmunit.BMScript;
import org.jboss.byteman.contrib.bmunit.BMUnitRunner;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.uberfire.ext.metadata.backend.lucene.index.LuceneIndex;
import org.uberfire.ext.metadata.engine.Index;
import org.uberfire.ext.metadata.io.BaseIndexTest;
import org.uberfire.ext.metadata.io.KObjectUtil;
import org.uberfire.ext.metadata.model.schema.MetaObject;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.attribute.FileAttribute;

@RunWith(value=BMUnitRunner.class)
@BMScript(value="byteman/index.btm")
public class IOServiceIndexedDotFileGitImplTest
extends BaseIndexTest {
    @Override
    protected String[] getRepositoryNames() {
        return new String[]{this.getClass().getSimpleName()};
    }

    @Test
    public void testIndexedDotFile() throws IOException, InterruptedException {
        this.setupCountDown(2);
        Path path = this.getBasePath(this.getClass().getSimpleName()).resolve("dotFile.txt");
        this.ioService().write(path, "ooooo!", Collections.emptySet(), new FileAttribute[0]);
        this.ioService().write(path, "ooooo!", Collections.emptySet(), this.getFileAttributes());
        this.waitForCountDown(5000);
        MetaObject mo = this.config.getMetaModelStore().getMetaObject(Path.class.getName());
        Assert.assertNotNull((Object)mo);
        Assert.assertNotNull((Object)mo.getProperty("name"));
        Assert.assertEquals((long)1L, (long)mo.getProperty("name").getTypes().size());
        Assert.assertTrue((boolean)mo.getProperty("name").getTypes().contains(String.class));
        Index index = this.config.getIndexManager().get(KObjectUtil.toKCluster((FileSystem)path.getFileSystem()));
        IndexSearcher searcher = ((LuceneIndex)index).nrtSearcher();
        TopScoreDocCollector collector = TopScoreDocCollector.create((int)10);
        searcher.search((Query)new TermQuery(new Term("name", "value")), (Collector)collector);
        ScoreDoc[] hits = collector.topDocs().scoreDocs;
        this.listHitPaths(searcher, hits);
        Assert.assertEquals((long)1L, (long)hits.length);
        ((LuceneIndex)index).nrtRelease(searcher);
    }

    private FileAttribute<?>[] getFileAttributes() {
        return new FileAttribute[]{new FileAttribute<String>(){

            public String name() {
                return "name";
            }

            public String value() {
                return "value";
            }
        }};
    }
}

