/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata.io;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.commons.async.DescriptiveRunnable;
import org.uberfire.commons.async.DisposableExecutor;
import org.uberfire.commons.async.SimpleAsyncExecutorService;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.ext.metadata.engine.Indexer;
import org.uberfire.ext.metadata.engine.MetaIndexEngine;
import org.uberfire.ext.metadata.engine.Observer;
import org.uberfire.ext.metadata.io.BatchIndex;
import org.uberfire.ext.metadata.io.IOServiceIndexedUtil;
import org.uberfire.ext.metadata.io.IndexersFactory;
import org.uberfire.ext.metadata.io.KObjectUtil;
import org.uberfire.ext.metadata.model.KCluster;
import org.uberfire.ext.metadata.model.KObject;
import org.uberfire.ext.metadata.model.KObjectKey;
import org.uberfire.io.IOService;
import org.uberfire.io.IOWatchService;
import org.uberfire.io.impl.IOServiceDotFileImpl;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.base.FSPath;
import org.uberfire.java.nio.base.WatchContext;
import org.uberfire.java.nio.base.dotfiles.DotFileUtils;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.DirectoryNotEmptyException;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.FileSystemAlreadyExistsException;
import org.uberfire.java.nio.file.FileSystemNotFoundException;
import org.uberfire.java.nio.file.NoSuchFileException;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.ProviderNotFoundException;
import org.uberfire.java.nio.file.StandardWatchEventKind;
import org.uberfire.java.nio.file.WatchEvent;
import org.uberfire.java.nio.file.WatchKey;
import org.uberfire.java.nio.file.WatchService;
import org.uberfire.java.nio.file.attribute.FileAttribute;
import org.uberfire.java.nio.file.attribute.FileAttributeView;

public class IOServiceIndexedImpl
extends IOServiceDotFileImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(IOServiceIndexedImpl.class);
    private final MetaIndexEngine indexEngine;
    private final BatchIndex batchIndex;
    private final Class<? extends FileAttributeView>[] views;
    private final List<FileSystem> watchedList = new ArrayList<FileSystem>();
    private final List<WatchService> watchServices = new ArrayList<WatchService>();
    private final Observer observer;

    public IOServiceIndexedImpl(MetaIndexEngine indexEngine, Class<? extends FileAttributeView> ... views) {
        this(indexEngine, new NOPObserver(), views);
    }

    public IOServiceIndexedImpl(String id, MetaIndexEngine indexEngine, Class<? extends FileAttributeView> ... views) {
        this(id, indexEngine, (Observer)new NOPObserver(), views);
    }

    public IOServiceIndexedImpl(IOWatchService watchService, MetaIndexEngine indexEngine, Class<? extends FileAttributeView> ... views) {
        this(watchService, indexEngine, (Observer)new NOPObserver(), views);
    }

    public IOServiceIndexedImpl(String id, IOWatchService watchService, MetaIndexEngine indexEngine, Class<? extends FileAttributeView> ... views) {
        this(id, watchService, indexEngine, new NOPObserver(), views);
    }

    public IOServiceIndexedImpl(MetaIndexEngine indexEngine, Observer observer, Class<? extends FileAttributeView> ... views) {
        this.indexEngine = (MetaIndexEngine)PortablePreconditions.checkNotNull((String)"indexEngine", (Object)indexEngine);
        this.observer = (Observer)PortablePreconditions.checkNotNull((String)"observer", (Object)observer);
        this.batchIndex = new BatchIndex(indexEngine, (IOService)this, observer, views);
        this.views = views;
    }

    public IOServiceIndexedImpl(String id, MetaIndexEngine indexEngine, Observer observer, Class<? extends FileAttributeView> ... views) {
        super(id);
        this.indexEngine = (MetaIndexEngine)PortablePreconditions.checkNotNull((String)"indexEngine", (Object)indexEngine);
        this.observer = (Observer)PortablePreconditions.checkNotNull((String)"observer", (Object)observer);
        this.batchIndex = new BatchIndex(indexEngine, (IOService)this, observer, views);
        this.views = views;
    }

    public IOServiceIndexedImpl(IOWatchService watchService, MetaIndexEngine indexEngine, Observer observer, Class<? extends FileAttributeView> ... views) {
        super(watchService);
        this.indexEngine = (MetaIndexEngine)PortablePreconditions.checkNotNull((String)"indexEngine", (Object)indexEngine);
        this.observer = (Observer)PortablePreconditions.checkNotNull((String)"observer", (Object)observer);
        this.batchIndex = new BatchIndex(indexEngine, (IOService)this, observer, views);
        this.views = views;
    }

    public IOServiceIndexedImpl(String id, IOWatchService watchService, MetaIndexEngine indexEngine, Observer observer, Class<? extends FileAttributeView> ... views) {
        super(id, watchService);
        this.indexEngine = (MetaIndexEngine)PortablePreconditions.checkNotNull((String)"indexEngine", (Object)indexEngine);
        this.observer = (Observer)PortablePreconditions.checkNotNull((String)"observer", (Object)observer);
        this.batchIndex = new BatchIndex(indexEngine, (IOService)this, observer, views);
        this.views = views;
    }

    public FileSystem getFileSystem(URI uri) throws IllegalArgumentException, FileSystemNotFoundException, ProviderNotFoundException, SecurityException {
        try {
            FileSystem fs = super.getFileSystem(uri);
            this.indexIfFresh(fs);
            this.setupWatchService(fs);
            return fs;
        }
        catch (IllegalArgumentException ex) {
            throw ex;
        }
        catch (FileSystemNotFoundException ex) {
            throw ex;
        }
        catch (ProviderNotFoundException ex) {
            throw ex;
        }
        catch (SecurityException ex) {
            throw ex;
        }
    }

    public FileSystem newFileSystem(URI uri, Map<String, ?> env) throws IllegalArgumentException, FileSystemAlreadyExistsException, ProviderNotFoundException, IOException, SecurityException {
        try {
            FileSystem fs = super.newFileSystem(uri, env);
            this.index(fs);
            this.setupWatchService(fs);
            return fs;
        }
        catch (IllegalArgumentException ex) {
            throw ex;
        }
        catch (FileSystemAlreadyExistsException ex) {
            throw ex;
        }
        catch (ProviderNotFoundException ex) {
            throw ex;
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (SecurityException ex) {
            throw ex;
        }
    }

    public int priority() {
        return 60;
    }

    public void dispose() {
        for (WatchService watchService : this.watchServices) {
            watchService.close();
        }
        super.dispose();
    }

    private void setupWatchService(FileSystem fs) {
        if (this.watchedList.contains(fs)) {
            return;
        }
        final WatchService ws = fs.newWatchService();
        this.watchedList.add(fs);
        this.watchServices.add(ws);
        final DisposableExecutor defaultInstance = SimpleAsyncExecutorService.getDefaultInstance();
        final DisposableExecutor unmanagedInstance = SimpleAsyncExecutorService.getUnmanagedInstance();
        SimpleAsyncExecutorService.getUnmanagedInstance().execute((Runnable)new DescriptiveRunnable(){

            public String getDescription() {
                return "IOServiceIndexedImpl(" + ws.toString() + ")";
            }

            public void run() {
                while (!IOServiceIndexedImpl.this.isDisposed && !ws.isClose()) {
                    WatchKey wk;
                    try {
                        wk = ws.take();
                    }
                    catch (Exception ex) {
                        break;
                    }
                    final List events = wk.pollEvents();
                    DescriptiveRunnable job = new DescriptiveRunnable(){

                        public String getDescription() {
                            return "IOServiceIndexedImpl(IndexOnEvent - " + ws.toString() + ")";
                        }

                        public void run() {
                            Path path;
                            WatchContext context;
                            HashSet<Class[]> eventRealPaths = new HashSet<Class[]>();
                            for (WatchEvent event : events) {
                                context = (WatchContext)event.context();
                                if (event.kind() != StandardWatchEventKind.ENTRY_MODIFY && event.kind() != StandardWatchEventKind.ENTRY_CREATE || (path = context.getPath()).getFileName().toString().startsWith(".")) continue;
                                eventRealPaths.add((Class[])path);
                            }
                            for (WatchEvent object : events) {
                                if (this.isDisposed()) {
                                    return;
                                }
                                try {
                                    context = (WatchContext)object.context();
                                    if (object.kind() == StandardWatchEventKind.ENTRY_MODIFY || object.kind() == StandardWatchEventKind.ENTRY_CREATE) {
                                        Path realPath;
                                        path = context.getPath();
                                        if (path.getFileName().toString().startsWith(".") && !IOServiceIndexedUtil.isBlackListed(path) && !eventRealPaths.contains(realPath = DotFileUtils.undot((Path)path))) {
                                            path = realPath;
                                        }
                                        if (!path.getFileName().toString().startsWith(".")) {
                                            realPath = IOServiceIndexedImpl.this.views;
                                            int n = ((Class[])realPath).length;
                                            for (int i = 0; i < n; ++i) {
                                                Class view = realPath[i];
                                                IOServiceIndexedImpl.this.getFileAttributeView(path, view);
                                            }
                                            FileAttribute[] allAttrs = IOServiceIndexedImpl.this.convert(IOServiceIndexedImpl.this.readAttributes(path));
                                            IOServiceIndexedImpl.this.indexEngine.index(KObjectUtil.toKObject(path, allAttrs));
                                            for (Indexer indexer : IndexersFactory.getIndexers()) {
                                                KObject kObject;
                                                if (this.isDisposed()) {
                                                    return;
                                                }
                                                if (!indexer.supportsPath(path) || (kObject = indexer.toKObject(path)) == null) continue;
                                                IOServiceIndexedImpl.this.indexEngine.index(kObject);
                                            }
                                        }
                                    }
                                    if (object.kind() == StandardWatchEventKind.ENTRY_RENAME) {
                                        Path sourcePath = context.getOldPath();
                                        Path destinationPath = context.getPath();
                                        IOServiceIndexedImpl.this.indexEngine.rename(KObjectUtil.toKObjectKey(sourcePath), KObjectUtil.toKObject(destinationPath, new FileAttribute[0]));
                                        for (Indexer indexer : IndexersFactory.getIndexers()) {
                                            if (this.isDisposed()) {
                                                return;
                                            }
                                            if (!indexer.supportsPath(destinationPath)) continue;
                                            KObjectKey kObjectSource = indexer.toKObjectKey(sourcePath);
                                            KObject kObjectDestination = indexer.toKObject(destinationPath);
                                            if (kObjectSource == null || kObjectDestination == null) continue;
                                            IOServiceIndexedImpl.this.indexEngine.rename(kObjectSource, kObjectDestination);
                                        }
                                    }
                                    if (object.kind() != StandardWatchEventKind.ENTRY_DELETE) continue;
                                    Path oldPath = context.getOldPath();
                                    IOServiceIndexedImpl.this.indexEngine.delete(KObjectUtil.toKObjectKey(oldPath));
                                    for (Indexer indexer : IndexersFactory.getIndexers()) {
                                        KObjectKey kObject;
                                        if (this.isDisposed()) {
                                            return;
                                        }
                                        if (!indexer.supportsPath(oldPath) || (kObject = indexer.toKObjectKey(oldPath)) == null) continue;
                                        IOServiceIndexedImpl.this.indexEngine.delete(kObject);
                                    }
                                }
                                catch (Exception ex) {
                                    LOGGER.error("Error during indexing. { " + object.toString() + " }", (Throwable)ex);
                                }
                            }
                        }

                        private boolean isDisposed() {
                            return IOServiceIndexedImpl.this.isDisposed || ws.isClose();
                        }
                    };
                    if (defaultInstance.equals(unmanagedInstance)) {
                        job.run();
                        continue;
                    }
                    defaultInstance.execute((Runnable)job);
                }
            }
        });
    }

    private synchronized void indexIfFresh(FileSystem fs) {
        KCluster cluster = KObjectUtil.toKCluster(fs);
        if (this.indexEngine.freshIndex(cluster)) {
            this.indexEngine.startBatch(cluster);
            this.index(fs);
        }
    }

    private void index(FileSystem fs) {
        this.batchIndex.runAsync(fs);
    }

    public void delete(Path path, DeleteOption ... options) throws IllegalArgumentException, NoSuchFileException, DirectoryNotEmptyException, IOException, SecurityException {
        KCluster cluster = KObjectUtil.toKCluster(path.getFileSystem());
        super.delete(path, options);
        if (path instanceof FSPath) {
            this.indexEngine.delete(cluster);
        }
    }

    public boolean deleteIfExists(Path path, DeleteOption ... options) throws IllegalArgumentException, DirectoryNotEmptyException, IOException, SecurityException {
        KCluster cluster = KObjectUtil.toKCluster(path.getFileSystem());
        boolean result = super.deleteIfExists(path, options);
        if (result && path instanceof FSPath) {
            this.indexEngine.delete(cluster);
        }
        return result;
    }

    public MetaIndexEngine getIndexEngine() {
        return this.indexEngine;
    }

    private static class NOPObserver
    implements Observer {
        private NOPObserver() {
        }

        public void information(String message) {
        }

        public void warning(String message) {
        }

        public void error(String message) {
        }
    }
}

