/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata.io;

import java.io.IOException;
import java.util.Collections;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.WildcardQuery;
import org.jboss.byteman.contrib.bmunit.BMScript;
import org.jboss.byteman.contrib.bmunit.BMUnitRunner;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.uberfire.ext.metadata.backend.lucene.index.LuceneIndex;
import org.uberfire.ext.metadata.engine.Index;
import org.uberfire.ext.metadata.io.BaseIndexTest;
import org.uberfire.ext.metadata.io.KObjectUtil;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.attribute.FileAttribute;

@RunWith(value=BMUnitRunner.class)
@BMScript(value="byteman/index.btm")
public class IOServiceIndexedSortingTest
extends BaseIndexTest {
    @Override
    protected String[] getRepositoryNames() {
        return new String[]{this.getClass().getSimpleName()};
    }

    @Test
    public void testSortedFiles() throws IOException, InterruptedException {
        this.setupCountDown(4);
        Path base = this.writeFile("cFile1.txt");
        this.writeFile("CFile2.txt");
        this.writeFile("bFile.txt");
        this.writeFile("aFile.txt");
        this.waitForCountDown(5000);
        Index index = this.config.getIndexManager().get(KObjectUtil.toKCluster((FileSystem)base.getFileSystem()));
        IndexSearcher searcher = ((LuceneIndex)index).nrtSearcher();
        Sort sort = new Sort(new SortField("filenamesorted", SortField.Type.STRING));
        WildcardQuery query = new WildcardQuery(new Term("filename", "*.txt"));
        TopFieldDocs docHits = searcher.search((Query)query, Integer.MAX_VALUE, sort);
        this.listHitPaths(searcher, docHits.scoreDocs);
        Assert.assertEquals((long)4L, (long)docHits.totalHits);
        Assert.assertEquals((Object)"aFile.txt", (Object)searcher.doc(docHits.scoreDocs[0].doc).get("filename"));
        Assert.assertEquals((Object)"bFile.txt", (Object)searcher.doc(docHits.scoreDocs[1].doc).get("filename"));
        Assert.assertEquals((Object)"cFile1.txt", (Object)searcher.doc(docHits.scoreDocs[2].doc).get("filename"));
        Assert.assertEquals((Object)"CFile2.txt", (Object)searcher.doc(docHits.scoreDocs[3].doc).get("filename"));
        ((LuceneIndex)index).nrtRelease(searcher);
    }

    private Path writeFile(String fileName) {
        Path path = this.getBasePath(this.getClass().getSimpleName()).resolve(fileName);
        this.ioService().write(path, "content", Collections.emptySet(), new FileAttribute[0]);
        return path;
    }
}

