/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata.io;

import java.io.IOException;
import java.util.Collections;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopScoreDocCollector;
import org.jboss.byteman.contrib.bmunit.BMScript;
import org.jboss.byteman.contrib.bmunit.BMUnitConfig;
import org.jboss.byteman.contrib.bmunit.BMUnitRunner;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.uberfire.ext.metadata.backend.lucene.index.LuceneIndex;
import org.uberfire.ext.metadata.engine.Index;
import org.uberfire.ext.metadata.io.BaseIndexTest;
import org.uberfire.ext.metadata.io.KObjectUtil;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.attribute.FileAttribute;

@RunWith(value=BMUnitRunner.class)
@BMUnitConfig(debug=true)
@BMScript(value="byteman/index.btm")
public class IOServiceIndexedDeleteFileTest
extends BaseIndexTest {
    @Override
    protected String[] getRepositoryNames() {
        return new String[]{this.getClass().getSimpleName()};
    }

    @Test
    public void testDeleteFile() throws IOException, InterruptedException {
        this.setupCountDown(1);
        Path path = this.getBasePath(this.getClass().getSimpleName()).resolve("delete-me.txt");
        this.ioService().write(path, "content", Collections.emptySet(), new FileAttribute[]{new FileAttribute<Object>(){

            public String name() {
                return "delete";
            }

            public Object value() {
                return "me";
            }
        }});
        this.waitForCountDown(5000);
        Index index = this.config.getIndexManager().get(KObjectUtil.toKCluster((FileSystem)path.getFileSystem()));
        IndexSearcher searcher = ((LuceneIndex)index).nrtSearcher();
        TopScoreDocCollector collector = TopScoreDocCollector.create((int)10);
        searcher.search((Query)new TermQuery(new Term("delete", "me")), (Collector)collector);
        ScoreDoc[] hits = collector.topDocs().scoreDocs;
        this.listHitPaths(searcher, hits);
        Assert.assertEquals((long)1L, (long)hits.length);
        this.setupCountDown(2);
        this.ioService().delete(path, new DeleteOption[0]);
        this.waitForCountDown(5000);
        searcher.search((Query)new TermQuery(new Term("delete", "me")), (Collector)collector);
        hits = collector.topDocs().scoreDocs;
        Assert.assertEquals((long)0L, (long)hits.length);
        ((LuceneIndex)index).nrtRelease(searcher);
    }
}

