/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata.io;

import java.io.IOException;
import java.util.Collections;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopScoreDocCollector;
import org.jboss.byteman.contrib.bmunit.BMScript;
import org.jboss.byteman.contrib.bmunit.BMUnitRunner;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.uberfire.ext.metadata.backend.lucene.index.LuceneIndex;
import org.uberfire.ext.metadata.engine.Index;
import org.uberfire.ext.metadata.io.BaseIndexTest;
import org.uberfire.ext.metadata.io.KObjectUtil;
import org.uberfire.ext.metadata.model.KObject;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.attribute.FileAttribute;

@RunWith(value=BMUnitRunner.class)
@BMScript(value="byteman/index.btm")
public class IOServiceIndexedDotFileGitInternalImplTest
extends BaseIndexTest {
    @Override
    protected String[] getRepositoryNames() {
        return new String[]{this.getClass().getSimpleName()};
    }

    @Test
    public void testIndexedGitInternalDotFile() throws IOException, InterruptedException {
        this.setupCountDown(1);
        Path path1 = this.getBasePath(this.getClass().getSimpleName()).resolve(".gitkeep");
        this.ioService().write(path1, "ooooo!", Collections.emptySet(), this.getFileAttributes());
        Path path2 = this.getBasePath(this.getClass().getSimpleName()).resolve("afile");
        this.ioService().write(path2, "ooooo!", Collections.emptySet(), this.getFileAttributes());
        this.waitForCountDown(5000);
        Index index = this.config.getIndexManager().get(KObjectUtil.toKCluster((FileSystem)path1.getFileSystem()));
        IndexSearcher searcher = ((LuceneIndex)index).nrtSearcher();
        TopScoreDocCollector collector = TopScoreDocCollector.create((int)10);
        searcher.search((Query)new TermQuery(new Term("name", "value")), (Collector)collector);
        ScoreDoc[] hits = collector.topDocs().scoreDocs;
        this.listHitPaths(searcher, hits);
        Assert.assertEquals((long)1L, (long)hits.length);
        KObject ko = org.uberfire.ext.metadata.backend.lucene.util.KObjectUtil.toKObject((Document)searcher.doc(hits[0].doc));
        Assert.assertEquals((Object)ko.getKey(), (Object)path2.toUri().toString());
        ((LuceneIndex)index).nrtRelease(searcher);
    }

    private FileAttribute<?>[] getFileAttributes() {
        return new FileAttribute[]{new FileAttribute<String>(){

            public String name() {
                return "name";
            }

            public String value() {
                return "value";
            }
        }};
    }
}

