/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata.io;

import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopScoreDocCollector;
import org.jboss.byteman.contrib.bmunit.BMScript;
import org.jboss.byteman.contrib.bmunit.BMUnitRunner;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.uberfire.ext.metadata.backend.lucene.index.LuceneIndex;
import org.uberfire.ext.metadata.engine.Index;
import org.uberfire.ext.metadata.io.BaseIndexTest;
import org.uberfire.ext.metadata.io.KObjectUtil;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.attribute.FileAttribute;

@RunWith(value=BMUnitRunner.class)
@BMScript(value="byteman/index.btm")
public class IOServiceIndexedGitImplTest
extends BaseIndexTest {
    protected final Date dateValue = new Date();

    @Override
    protected String[] getRepositoryNames() {
        return new String[]{this.getClass().getSimpleName()};
    }

    @Test
    public void testIndexedFile() throws IOException, InterruptedException {
        this.setupCountDown(2);
        Path path1 = this.getBasePath(this.getClass().getSimpleName()).resolve("myIndexedFile.txt");
        this.ioService().write(path1, "ooooo!", Collections.emptySet(), new FileAttribute[]{new FileAttribute<Object>(){

            public String name() {
                return "custom";
            }

            public Object value() {
                return IOServiceIndexedGitImplTest.this.dateValue;
            }
        }, new FileAttribute<String>(){

            public String name() {
                return "int.hello";
            }

            public String value() {
                return "hello some world jhere";
            }
        }, new FileAttribute<Integer>(){

            public String name() {
                return "int";
            }

            public Integer value() {
                return 10;
            }
        }});
        Path path2 = this.getBasePath(this.getClass().getSimpleName()).resolve("myOtherIndexedFile.txt");
        this.ioService().write(path2, "ooooo!", Collections.emptySet(), new FileAttribute[]{new FileAttribute<String>(){

            public String name() {
                return "int.hello";
            }

            public String value() {
                return "jhere";
            }
        }});
        this.waitForCountDown(5000);
        Assert.assertNotNull((Object)this.config.getMetaModelStore().getMetaObject(Path.class.getName()));
        Assert.assertNotNull((Object)this.config.getMetaModelStore().getMetaObject(Path.class.getName()).getProperty("int"));
        Assert.assertNotNull((Object)this.config.getMetaModelStore().getMetaObject(Path.class.getName()).getProperty("int.hello"));
        Assert.assertNotNull((Object)this.config.getMetaModelStore().getMetaObject(Path.class.getName()).getProperty("custom"));
        Assert.assertNotNull((Object)this.config.getMetaModelStore().getMetaObject(Path.class.getName()).getProperty("int"));
        Assert.assertNotNull((Object)this.config.getMetaModelStore().getMetaObject(Path.class.getName()).getProperty("int.hello"));
        Assert.assertNotNull((Object)this.config.getMetaModelStore().getMetaObject(Path.class.getName()).getProperty("custom"));
        Assert.assertEquals((long)1L, (long)this.config.getMetaModelStore().getMetaObject(Path.class.getName()).getProperty("int").getTypes().size());
        Assert.assertEquals((long)1L, (long)this.config.getMetaModelStore().getMetaObject(Path.class.getName()).getProperty("int.hello").getTypes().size());
        Assert.assertEquals((long)1L, (long)this.config.getMetaModelStore().getMetaObject(Path.class.getName()).getProperty("custom").getTypes().size());
        Assert.assertTrue((boolean)this.config.getMetaModelStore().getMetaObject(Path.class.getName()).getProperty("int").getTypes().contains(Integer.class));
        Assert.assertTrue((boolean)this.config.getMetaModelStore().getMetaObject(Path.class.getName()).getProperty("int.hello").getTypes().contains(String.class));
        Assert.assertTrue((boolean)this.config.getMetaModelStore().getMetaObject(Path.class.getName()).getProperty("custom").getTypes().contains(Date.class));
        Index index = this.config.getIndexManager().get(KObjectUtil.toKCluster((FileSystem)path2.getFileSystem()));
        IndexSearcher searcher = ((LuceneIndex)index).nrtSearcher();
        TopScoreDocCollector collector = TopScoreDocCollector.create((int)10);
        searcher.search((Query)new TermQuery(new Term("int.hello", "world")), (Collector)collector);
        ScoreDoc[] hits = collector.topDocs().scoreDocs;
        this.listHitPaths(searcher, hits);
        Assert.assertEquals((long)1L, (long)hits.length);
        collector = TopScoreDocCollector.create((int)10);
        searcher.search((Query)new TermQuery(new Term("int.hello", "jhere")), (Collector)collector);
        hits = collector.topDocs().scoreDocs;
        this.listHitPaths(searcher, hits);
        Assert.assertEquals((long)2L, (long)hits.length);
        collector = TopScoreDocCollector.create((int)10);
        searcher.search((Query)new MatchAllDocsQuery(), (Collector)collector);
        hits = collector.topDocs().scoreDocs;
        this.listHitPaths(searcher, hits);
        Assert.assertEquals((long)2L, (long)hits.length);
        ((LuceneIndex)index).nrtRelease(searcher);
    }
}

