/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata.io.infinispan;

import java.net.URI;
import org.jboss.byteman.contrib.bmunit.BMScript;
import org.jboss.byteman.contrib.bmunit.BMUnitConfig;
import org.jboss.byteman.contrib.bmunit.BMUnitRunner;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.uberfire.ext.metadata.io.infinispan.BaseIndexTest;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;

@RunWith(value=BMUnitRunner.class)
@BMUnitConfig(debug=true)
@BMScript(dir="byteman", value="infinispan.btm")
public class BatchIndexSingleThreadTest
extends BaseIndexTest {
    @Override
    protected String[] getRepositoryNames() {
        return new String[]{"infinispan/" + this.getClass().getSimpleName()};
    }

    @Test
    public void testSingleBatchIndexExecution() throws InterruptedException {
        Path path1 = this.getBasePath("infinispan/" + this.getClass().getSimpleName()).resolve("xxx");
        this.ioService().write(path1, "xxx!", new OpenOption[0]);
        this.setupCountDown(3);
        URI fsURI = URI.create("git://infinispan/" + this.getClass().getSimpleName() + "/file1");
        FileSystem fs1 = this.ioService().getFileSystem(fsURI);
        Assert.assertNotNull((Object)fs1);
        FileSystem fs2 = this.ioService().getFileSystem(fsURI);
        Assert.assertNotNull((Object)fs2);
        FileSystem fs3 = this.ioService().getFileSystem(fsURI);
        Assert.assertNotNull((Object)fs3);
        this.waitForCountDown(10000);
        Assert.assertEquals((long)1L, (long)this.getStartBatchCount());
    }
}

