/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata.io.infinispan;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.WildcardQuery;
import org.jboss.byteman.contrib.bmunit.BMScript;
import org.jboss.byteman.contrib.bmunit.BMUnitRunner;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.uberfire.commons.async.DescriptiveThreadFactory;
import org.uberfire.ext.metadata.backend.lucene.analyzer.FilenameAnalyzer;
import org.uberfire.ext.metadata.io.IOServiceIndexedImpl;
import org.uberfire.ext.metadata.io.MetadataConfigBuilder;
import org.uberfire.ext.metadata.io.infinispan.BaseIndexTest;
import org.uberfire.io.IOService;
import org.uberfire.io.attribute.DublinCoreView;
import org.uberfire.java.nio.base.version.VersionAttributeView;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.attribute.FileAttribute;

@RunWith(value=BMUnitRunner.class)
@BMScript(dir="byteman", value="infinispan.btm")
public class ComplexFieldsTest
extends BaseIndexTest {
    @Override
    protected IOService ioService() {
        if (this.ioService == null) {
            this.config = new MetadataConfigBuilder("infinispan").withInMemoryMetaModelStore().useDirectoryBasedIndex().useInMemoryDirectory().usingAnalyzers((Map)new HashMap<String, Analyzer>(){
                {
                    this.put("file", new FilenameAnalyzer());
                }
            }).build();
            this.ioService = new IOServiceIndexedImpl(this.config.getIndexEngine(), Executors.newCachedThreadPool((ThreadFactory)new DescriptiveThreadFactory()), this.indexersFactory(), this.indexerDispatcherFactory(this.config.getIndexEngine()), new Class[]{DublinCoreView.class, VersionAttributeView.class});
        }
        return this.ioService;
    }

    @Override
    protected String[] getRepositoryNames() {
        return new String[]{"elastic_complex_fields_test"};
    }

    @Test
    public void testIndex() throws IOException, InterruptedException {
        this.setupCountDown(1);
        Path file = this.ioService().get("git://elastic_complex_fields_test/path/to/file.txt", new String[0]);
        this.ioService().write(file, "some content here", Collections.emptySet(), new FileAttribute[]{new FileAttribute<Object>(){

            public String name() {
                return "file";
            }

            public Object value() {
                return "default://master@file/kie";
            }
        }});
        this.waitForCountDown(5000);
        this.setupCountDown(1);
        file = this.ioService().get("git://elastic_complex_fields_test/path/to/files.txt", new String[0]);
        this.ioService().write(file, "some content here", Collections.emptySet(), new FileAttribute[]{new FileAttribute<Object>(){

            public String name() {
                return "file";
            }

            public Object value() {
                return "default://master@files/kie";
            }
        }});
        this.waitForCountDown(5000);
        List result = this.config.getIndexProvider().findByQuery(Arrays.asList("elastic_complex_fields_test"), (Query)new WildcardQuery(new Term("file", "default://master@files/kie")), null, 0);
        Assert.assertEquals((long)1L, (long)result.size());
        result = this.config.getIndexProvider().findByQuery(Arrays.asList("elastic_complex_fields_test"), (Query)new WildcardQuery(new Term("file", "default://master@file/kie")), null, 0);
        Assert.assertEquals((long)1L, (long)result.size());
        result = this.config.getIndexProvider().findByQuery(Arrays.asList("elastic_complex_fields_test"), (Query)new WildcardQuery(new Term("file", "default://master@notFound")), null, 0);
        Assert.assertEquals((long)0L, (long)result.size());
    }
}

