/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata.io.infinispan;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.jboss.byteman.contrib.bmunit.BMScript;
import org.jboss.byteman.contrib.bmunit.BMUnitConfig;
import org.jboss.byteman.contrib.bmunit.BMUnitRunner;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.uberfire.ext.metadata.io.KObjectUtil;
import org.uberfire.ext.metadata.io.infinispan.BaseIndexTest;
import org.uberfire.ext.metadata.provider.IndexProvider;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.attribute.FileAttribute;

@RunWith(value=BMUnitRunner.class)
@BMUnitConfig(debug=true)
@BMScript(dir="byteman", value="infinispan.btm")
public class IOServiceIndexedDeleteFileTest
extends BaseIndexTest {
    @Override
    protected String[] getRepositoryNames() {
        return new String[]{this.getSimpleName()};
    }

    @Test
    public void testDeleteFile() {
        this.setupCountDown(1);
        Path path = this.getBasePath(this.getSimpleName()).resolve("delete-me.txt");
        this.ioService().write(path, "content", Collections.emptySet(), new FileAttribute[]{new FileAttribute<Object>(){

            public String name() {
                return "delete";
            }

            public Object value() {
                return "me";
            }
        }});
        this.waitForCountDown(10000);
        List<String> indices = Arrays.asList(KObjectUtil.toKCluster((Path)path).getClusterId());
        IndexProvider provider = this.config.getIndexProvider();
        long hits = provider.findHitsByQuery(indices, (Query)new TermQuery(new Term("delete", "me")));
        Assert.assertEquals((long)1L, (long)hits);
        this.setupCountDown(2);
        this.ioService().delete(path, new DeleteOption[0]);
        this.waitForCountDown(10000);
        hits = provider.findHitsByQuery(indices, (Query)new TermQuery(new Term("delete", "me")));
        Assert.assertEquals((long)0L, (long)hits);
    }
}

