/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata.io.common.util;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.channels.FileChannel;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.base.FileSystemId;
import org.uberfire.java.nio.channels.AsynchronousFileChannel;
import org.uberfire.java.nio.channels.SeekableByteChannel;
import org.uberfire.java.nio.file.AccessDeniedException;
import org.uberfire.java.nio.file.AccessMode;
import org.uberfire.java.nio.file.AtomicMoveNotSupportedException;
import org.uberfire.java.nio.file.CopyOption;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.DirectoryNotEmptyException;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.FileAlreadyExistsException;
import org.uberfire.java.nio.file.FileStore;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.FileSystemAlreadyExistsException;
import org.uberfire.java.nio.file.FileSystemNotFoundException;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.NoSuchFileException;
import org.uberfire.java.nio.file.NotDirectoryException;
import org.uberfire.java.nio.file.NotLinkException;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.attribute.BasicFileAttributes;
import org.uberfire.java.nio.file.attribute.FileAttribute;
import org.uberfire.java.nio.file.attribute.FileAttributeView;
import org.uberfire.java.nio.file.spi.FileSystemProvider;

public class TestFileSystemProvider
implements FileSystemProvider {
    public static String SCHEME = "test";
    private boolean isDefault = false;
    private FileSystemProvider internalMock;

    public void resetMock() {
        this.internalMock = (FileSystemProvider)Mockito.mock(FileSystemProvider.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
    }

    public FileSystemProvider getMock() {
        return this.internalMock;
    }

    public void forceAsDefault() {
        this.isDefault = true;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public String getScheme() {
        return SCHEME;
    }

    public FileSystem newFileSystem(URI uri, Map<String, ?> env) throws IllegalArgumentException, IOException, SecurityException, FileSystemAlreadyExistsException {
        return this.internalMock.newFileSystem(uri, env);
    }

    public FileSystem getFileSystem(URI uri) throws IllegalArgumentException, FileSystemNotFoundException, SecurityException {
        return this.internalMock.getFileSystem(uri);
    }

    public Path getPath(URI uri) throws IllegalArgumentException, FileSystemNotFoundException, SecurityException {
        return this.internalMock.getPath(uri);
    }

    public FileSystem newFileSystem(Path path, Map<String, ?> env) throws IllegalArgumentException, UnsupportedOperationException, IOException, SecurityException {
        return this.internalMock.newFileSystem(path, env);
    }

    public InputStream newInputStream(Path path, OpenOption ... options) throws IllegalArgumentException, UnsupportedOperationException, NoSuchFileException, IOException, SecurityException {
        return this.internalMock.newInputStream(path, options);
    }

    public OutputStream newOutputStream(Path path, OpenOption ... options) throws IllegalArgumentException, UnsupportedOperationException, IOException, SecurityException {
        return this.internalMock.newOutputStream(path, options);
    }

    public FileChannel newFileChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IllegalArgumentException, UnsupportedOperationException, IOException, SecurityException {
        return this.internalMock.newFileChannel(path, options, attrs);
    }

    public AsynchronousFileChannel newAsynchronousFileChannel(Path path, Set<? extends OpenOption> options, ExecutorService executor, FileAttribute<?> ... attrs) throws IllegalArgumentException, UnsupportedOperationException, IOException, SecurityException {
        return this.internalMock.newAsynchronousFileChannel(path, options, executor, attrs);
    }

    public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IllegalArgumentException, UnsupportedOperationException, FileAlreadyExistsException, IOException, SecurityException {
        return this.internalMock.newByteChannel(path, options, attrs);
    }

    public DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter<Path> filter) throws NotDirectoryException, IOException, SecurityException {
        return this.internalMock.newDirectoryStream(dir, filter);
    }

    public void createDirectory(Path dir, FileAttribute<?> ... attrs) throws UnsupportedOperationException, FileAlreadyExistsException, IOException, SecurityException {
        this.internalMock.createDirectory(dir, attrs);
    }

    public void createSymbolicLink(Path link, Path target, FileAttribute<?> ... attrs) throws UnsupportedOperationException, FileAlreadyExistsException, IOException, SecurityException {
        this.internalMock.createSymbolicLink(link, target, attrs);
    }

    public void createLink(Path link, Path existing) throws UnsupportedOperationException, FileAlreadyExistsException, IOException, SecurityException {
        this.internalMock.createLink(link, existing);
    }

    public void delete(Path path, DeleteOption ... options) throws DirectoryNotEmptyException, NoSuchFileException, IOException, SecurityException {
        this.internalMock.delete(path, options);
    }

    public boolean deleteIfExists(Path path, DeleteOption ... options) throws DirectoryNotEmptyException, IOException, SecurityException {
        return this.internalMock.deleteIfExists(path, options);
    }

    public Path readSymbolicLink(Path link) throws UnsupportedOperationException, NotLinkException, IOException, SecurityException {
        return this.internalMock.readSymbolicLink(link);
    }

    public void copy(Path source, Path target, CopyOption ... options) throws UnsupportedOperationException, FileAlreadyExistsException, DirectoryNotEmptyException, IOException, SecurityException {
        this.internalMock.copy(source, target, options);
    }

    public void move(Path source, Path target, CopyOption ... options) throws DirectoryNotEmptyException, AtomicMoveNotSupportedException, IOException, SecurityException {
        this.internalMock.move(source, target, options);
    }

    public boolean isSameFile(Path path, Path path2) throws IOException, SecurityException {
        return this.internalMock.isSameFile(path, path2);
    }

    public boolean isHidden(Path path) throws IllegalArgumentException, IOException, SecurityException {
        return this.internalMock.isHidden(path);
    }

    public FileStore getFileStore(Path path) throws IOException, SecurityException {
        return this.internalMock.getFileStore(path);
    }

    public void checkAccess(Path path, AccessMode ... modes) throws UnsupportedOperationException, NoSuchFileException, AccessDeniedException, IOException, SecurityException {
        this.internalMock.checkAccess(path, modes);
    }

    public <V extends FileAttributeView> V getFileAttributeView(Path path, Class<V> type, LinkOption ... options) throws NoSuchFileException {
        return (V)this.internalMock.getFileAttributeView(path, type, options);
    }

    public <A extends BasicFileAttributes> A readAttributes(Path path, Class<A> type, LinkOption ... options) throws NoSuchFileException, UnsupportedOperationException, IOException, SecurityException {
        return (A)this.internalMock.readAttributes(path, type, options);
    }

    public Map<String, Object> readAttributes(Path path, String attributes, LinkOption ... options) throws UnsupportedOperationException, IllegalArgumentException, IOException, SecurityException {
        return this.internalMock.readAttributes(path, attributes, options);
    }

    public void setAttribute(Path path, String attribute, Object value, LinkOption ... options) throws UnsupportedOperationException, IllegalArgumentException, ClassCastException, IOException, SecurityException {
        this.internalMock.setAttribute(path, attribute, value, options);
    }

    public static abstract class MockFileSystem
    implements FileSystem,
    FileSystemId {
    }
}

