/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata.io;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InOrder;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.metadata.engine.MetaIndexEngine;
import org.uberfire.ext.metadata.io.IOServiceIndexedImpl;
import org.uberfire.ext.metadata.io.IndexerDispatcher;
import org.uberfire.ext.metadata.io.IndexersFactory;
import org.uberfire.ext.metadata.io.common.util.TestFileSystemProvider;
import org.uberfire.ext.metadata.model.KCluster;
import org.uberfire.java.nio.base.AttrsStorage;
import org.uberfire.java.nio.base.FSPath;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.WatchService;
import org.uberfire.java.nio.file.api.FileSystemProviders;
import org.uberfire.java.nio.file.spi.FileSystemProvider;
import org.uberfire.java.nio.fs.jgit.JGitPathImpl;

@RunWith(value=MockitoJUnitRunner.class)
public class IOServiceIndexedTest {
    IOServiceIndexedImpl ioService;
    @Mock
    MetaIndexEngine indexEngine;
    @Mock
    ExecutorService executorService;
    @Mock
    IndexersFactory indexersFactory;
    @Mock
    IndexerDispatcher.IndexerDispatcherFactory dispatcherFactory;
    FileSystemProvider mockProvider;

    @Before
    public void setup() throws URISyntaxException {
        TestFileSystemProvider testProvider = FileSystemProviders.installedProviders().stream().filter(provider -> provider instanceof TestFileSystemProvider).map(provider -> (TestFileSystemProvider)provider).findAny().orElseThrow(() -> new RuntimeException("Failed to setup mock provider for test."));
        testProvider.resetMock();
        this.mockProvider = testProvider.getMock();
        Mockito.when((Object)this.mockProvider.newFileSystem((URI)Matchers.any(URI.class), (Map)Matchers.any())).thenReturn(Mockito.mock(TestFileSystemProvider.MockFileSystem.class, (Answer)Mockito.RETURNS_DEEP_STUBS));
        Mockito.when((Object)this.mockProvider.newFileSystem((Path)Matchers.any(Path.class), (Map)Matchers.any())).thenReturn(Mockito.mock(TestFileSystemProvider.MockFileSystem.class, (Answer)Mockito.RETURNS_DEEP_STUBS));
        Mockito.when((Object)this.mockProvider.getFileSystem((URI)Matchers.any(URI.class))).thenReturn(Mockito.mock(TestFileSystemProvider.MockFileSystem.class, (Answer)Mockito.RETURNS_DEEP_STUBS));
        this.ioService = (IOServiceIndexedImpl)Mockito.spy((Object)new IOServiceIndexedImpl(this.indexEngine, this.executorService, this.indexersFactory, this.dispatcherFactory, new Class[0]));
    }

    @Test
    public void recreatingFileSystemMakesNewWatchService() throws Exception {
        URI uri = new URI("test:///some/path");
        Map env = Collections.emptyMap();
        FileSystem fs1 = this.ioService.newFileSystem(uri, env);
        ((FileSystem)Mockito.verify((Object)fs1)).newWatchService();
        FSPath fsPath = (FSPath)Mockito.mock(FSPath.class);
        Mockito.when((Object)fsPath.getFileSystem()).thenReturn((Object)fs1);
        this.ioService.delete((Path)fsPath, new DeleteOption[0]);
        ((WatchService)Mockito.verify((Object)fs1.newWatchService())).close();
        FileSystem fs2 = this.ioService.newFileSystem(uri, env);
        ((FileSystem)Mockito.verify((Object)fs2, (VerificationMode)Mockito.times((int)3))).newWatchService();
    }

    @Test
    public void deleteFSTest() throws Exception {
        FileSystem fileSystem = this.getFileSystem();
        FSPath fsPath = (FSPath)Mockito.mock(FSPath.class);
        Mockito.when((Object)fsPath.getFileSystem()).thenReturn((Object)fileSystem);
        this.ioService.delete((Path)fsPath, new DeleteOption[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.ioService, this.indexEngine, fileSystem});
        ((MetaIndexEngine)inOrder.verify((Object)this.indexEngine)).delete((KCluster)Matchers.any(KCluster.class));
        ((IOServiceIndexedImpl)inOrder.verify((Object)this.ioService)).deleteRepositoryFiles((Path)Matchers.eq((Object)fsPath), (DeleteOption[])Matchers.any());
    }

    @Test
    public void deleteBranchTest() throws Exception {
        FileSystem fileSystem = this.getFileSystem();
        Path branchPath = (Path)fileSystem.getRootDirectories().iterator().next();
        this.ioService.delete(branchPath, new DeleteOption[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.ioService, this.indexEngine, fileSystem});
        ((MetaIndexEngine)inOrder.verify((Object)this.indexEngine)).delete((KCluster)Matchers.any(KCluster.class));
        ((IOServiceIndexedImpl)inOrder.verify((Object)this.ioService)).deleteRepositoryFiles((Path)Matchers.eq((Object)branchPath), (DeleteOption[])Matchers.any());
    }

    @Test
    public void deleteFileTest() throws Exception {
        FileSystem fileSystem = this.getFileSystem();
        Path file = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)file.getFileSystem()).thenReturn((Object)fileSystem);
        this.ioService.delete(file, new DeleteOption[0]);
        ((MetaIndexEngine)Mockito.verify((Object)this.indexEngine, (VerificationMode)Mockito.never())).delete((KCluster)Matchers.any(KCluster.class));
        ((IOServiceIndexedImpl)Mockito.verify((Object)this.ioService)).deleteRepositoryFiles((Path)Matchers.eq((Object)file), (DeleteOption[])Matchers.any());
    }

    private FileSystem getFileSystem() throws URISyntaxException {
        URI uri = new URI("test:///some/path");
        Map env = Collections.emptyMap();
        FileSystem fileSystem = this.ioService.newFileSystem(uri, env);
        Path fsRootDirectory1 = (Path)Mockito.mock(JGitPathImpl.class);
        Mockito.when((Object)fsRootDirectory1.getFileSystem()).thenReturn((Object)fileSystem);
        Mockito.when((Object)fsRootDirectory1.getRoot()).thenReturn((Object)fsRootDirectory1);
        Mockito.when((Object)((JGitPathImpl)fsRootDirectory1).getAttrStorage()).thenReturn(Mockito.mock(AttrsStorage.class));
        Path fsRootDirectory2 = (Path)Mockito.mock(JGitPathImpl.class);
        Mockito.when((Object)fsRootDirectory2.getFileSystem()).thenReturn((Object)fileSystem);
        Mockito.when((Object)fsRootDirectory2.getRoot()).thenReturn((Object)fsRootDirectory2);
        Mockito.when((Object)((JGitPathImpl)fsRootDirectory2).getAttrStorage()).thenReturn(Mockito.mock(AttrsStorage.class));
        List<Path> fsRootDirectories = Arrays.asList(fsRootDirectory1, fsRootDirectory2);
        ((FileSystem)Mockito.doReturn(fsRootDirectories).when((Object)fileSystem)).getRootDirectories();
        return fileSystem;
    }
}

