/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata.io.elasticsearch.suite;

import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.exceptions.DockerException;
import org.junit.runner.RunWith;
import org.junit.runners.Suite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.ext.metadata.io.elasticsearch.BatchIndexConcurrencyTest;
import org.uberfire.ext.metadata.io.elasticsearch.BatchIndexSingleThreadTest;
import org.uberfire.ext.metadata.io.elasticsearch.BatchIndexTest;
import org.uberfire.ext.metadata.io.elasticsearch.ComplexFieldsTest;
import org.uberfire.ext.metadata.io.elasticsearch.ElasticFullTextSearchIndexTest;
import org.uberfire.ext.metadata.io.elasticsearch.ElasticSearchIndexTest;
import org.uberfire.ext.metadata.io.elasticsearch.IOSearchServiceImplTest;
import org.uberfire.ext.metadata.io.elasticsearch.IOServiceIndexedDeleteFileTest;
import org.uberfire.ext.metadata.io.elasticsearch.IOServiceIndexedDotFileGitImplTest;
import org.uberfire.ext.metadata.io.elasticsearch.IOServiceIndexedDotFileGitInternalImplTest;
import org.uberfire.ext.metadata.io.elasticsearch.IOServiceIndexedGitImplTest;
import org.uberfire.ext.metadata.io.elasticsearch.IOServiceIndexedSortingTest;
import org.uberfire.ext.metadata.io.elasticsearch.ReplaceIndexedObjectTest;
import pl.domzal.junit.docker.rule.DockerRule;
import pl.domzal.junit.docker.rule.StopOption;
import pl.domzal.junit.docker.rule.WaitFor;

@RunWith(value=Suite.class)
@Suite.SuiteClasses(value={BatchIndexConcurrencyTest.class, BatchIndexSingleThreadTest.class, BatchIndexTest.class, ComplexFieldsTest.class, ElasticFullTextSearchIndexTest.class, ElasticSearchIndexTest.class, IOSearchServiceImplTest.class, IOServiceIndexedDeleteFileTest.class, IOServiceIndexedDotFileGitImplTest.class, IOServiceIndexedDotFileGitInternalImplTest.class, IOServiceIndexedGitImplTest.class, IOServiceIndexedSortingTest.class, ReplaceIndexedObjectTest.class})
public class ElasticSearchTestSuite {
    private static Logger logger = LoggerFactory.getLogger(ElasticSearchTestSuite.class);
    private static String image = "docker.elastic.co/elasticsearch/elasticsearch:5.6.1";
    public static final String CONTAINER_NAME = "kie-elasticsearch";
    public static DockerRule elasticsearchRule = DockerRule.builder().imageName(image).name("kie-elasticsearch").env("cluster.name", "kie-cluster").env("discovery.type", "single-node").env("http.host", "0.0.0.0").env("transport.host", "0.0.0.0").env("transport.tcp.port", "9300").env("xpack.security.enabled", "false").stopOptions(new StopOption[]{StopOption.KILL, StopOption.REMOVE}).waitForTimeout(60).expose("9200", "9200").expose("9300", "9300").waitFor(WaitFor.logMessage((String)"mode [trial] - valid")).build();

    private static boolean existContainer() throws DockerException, InterruptedException {
        return elasticsearchRule.getDockerClient().listContainers(new DockerClient.ListContainersParam[]{DockerClient.ListContainersParam.allContainers((boolean)true)}).stream().anyMatch(container -> container.names().contains("/kie-elasticsearch"));
    }

    public static void before() throws Throwable {
        if (ElasticSearchTestSuite.existContainer()) {
            logger.info("Container exists, removing");
            if (elasticsearchRule.getDockerClient().inspectContainer(CONTAINER_NAME).state().running().booleanValue()) {
                elasticsearchRule.getDockerClient().killContainer(CONTAINER_NAME);
            }
            elasticsearchRule.getDockerClient().removeContainer(CONTAINER_NAME);
        } else {
            logger.info("Container does not exist");
        }
        logger.info("Creating container");
        elasticsearchRule.before();
    }

    public static void after() {
        elasticsearchRule.after();
    }
}

