/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata.io.elasticsearch;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.jboss.byteman.contrib.bmunit.BMScript;
import org.jboss.byteman.contrib.bmunit.BMUnitRunner;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.uberfire.ext.metadata.io.KObjectUtil;
import org.uberfire.ext.metadata.io.elasticsearch.BaseIndexTest;
import org.uberfire.ext.metadata.model.KObject;
import org.uberfire.ext.metadata.provider.IndexProvider;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.attribute.FileAttribute;

@RunWith(value=BMUnitRunner.class)
@BMScript(value="byteman/elastic.btm")
public class IOServiceIndexedDotFileGitInternalImplTest
extends BaseIndexTest {
    @Override
    protected String[] getRepositoryNames() {
        return new String[]{this.getSimpleName()};
    }

    @Test
    public void testIndexedGitInternalDotFile() throws IOException, InterruptedException {
        this.setupCountDown(2);
        Path path1 = this.getBasePath(this.getSimpleName()).resolve(".gitkeep");
        this.ioService().write(path1, "ooooo!", Collections.emptySet(), this.getFileAttributes());
        Path path2 = this.getBasePath(this.getSimpleName()).resolve("afile");
        this.ioService().write(path2, "ooooo!", Collections.emptySet(), this.getFileAttributes());
        this.waitForCountDown(10000);
        List<String> indices = Arrays.asList(KObjectUtil.toKCluster((FileSystem)path1.getFileSystem()).getClusterId());
        IndexProvider provider = this.config.getIndexProvider();
        List hits = provider.findByQuery(indices, (Query)new TermQuery(new Term("name", "value")), 10);
        Assert.assertEquals((long)1L, (long)hits.size());
        Assert.assertEquals((Object)((KObject)hits.get(0)).getKey(), (Object)path2.toUri().toString());
    }

    private FileAttribute<?>[] getFileAttributes() {
        return new FileAttribute[]{new FileAttribute<String>(){

            public String name() {
                return "name";
            }

            public String value() {
                return "value";
            }
        }};
    }
}

