/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata.io.lucene;

import java.io.IOException;
import java.util.List;
import org.jboss.byteman.contrib.bmunit.BMScript;
import org.jboss.byteman.contrib.bmunit.BMUnitRunner;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.uberfire.ext.metadata.io.IOSearchServiceImpl;
import org.uberfire.ext.metadata.io.lucene.BaseIndexTest;
import org.uberfire.ext.metadata.search.IOSearchService;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;

@RunWith(value=BMUnitRunner.class)
@BMScript(value="byteman/lucene.btm")
public class IOSearchServiceImplTest
extends BaseIndexTest {
    @Override
    protected String[] getRepositoryNames() {
        return new String[]{this.getClass().getSimpleName()};
    }

    @Test
    public void testFullTextSearch() throws IOException, InterruptedException {
        this.setupCountDown(3);
        IOSearchServiceImpl searchIndex = new IOSearchServiceImpl(this.config.getSearchIndex(), this.ioService());
        Path path1 = this.getBasePath(this.getClass().getSimpleName()).resolve("g.txt");
        this.ioService().write(path1, "ooooo!", new OpenOption[0]);
        Path path2 = this.getBasePath(this.getClass().getSimpleName()).resolve("a.txt");
        this.ioService().write(path2, "ooooo!", new OpenOption[0]);
        Path path3 = this.getBasePath(this.getClass().getSimpleName()).resolve("the.txt");
        this.ioService().write(path3, "ooooo!", new OpenOption[0]);
        Path root = path1.getRoot();
        this.waitForCountDown(5000);
        List result = searchIndex.fullTextSearch("g", (IOSearchService.Filter)new IOSearchService.NoOpFilter(), new Path[]{root});
        Assert.assertEquals((long)1L, (long)result.size());
        result = searchIndex.fullTextSearch("a", (IOSearchService.Filter)new IOSearchService.NoOpFilter(), new Path[]{root});
        Assert.assertEquals((long)1L, (long)result.size());
        result = searchIndex.fullTextSearch("the", (IOSearchService.Filter)new IOSearchService.NoOpFilter(), new Path[]{root});
        Assert.assertEquals((long)1L, (long)result.size());
        result = searchIndex.fullTextSearch("", (IOSearchService.Filter)new IOSearchService.NoOpFilter(), new Path[]{root});
        Assert.assertEquals((long)0L, (long)result.size());
        try {
            searchIndex.fullTextSearch(null, (IOSearchService.Filter)new IOSearchService.NoOpFilter(), new Path[]{root});
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

