/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata.io.lucene;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.jboss.byteman.contrib.bmunit.BMScript;
import org.jboss.byteman.contrib.bmunit.BMUnitRunner;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.uberfire.ext.metadata.io.KObjectUtil;
import org.uberfire.ext.metadata.io.lucene.BaseIndexTest;
import org.uberfire.ext.metadata.model.schema.MetaObject;
import org.uberfire.ext.metadata.model.schema.MetaProperty;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.attribute.FileAttribute;

@RunWith(value=BMUnitRunner.class)
@BMScript(value="byteman/lucene.btm")
public class IOServiceIndexedDotFileGitImplTest
extends BaseIndexTest {
    @Override
    protected String[] getRepositoryNames() {
        return new String[]{this.getClass().getSimpleName()};
    }

    @Test
    public void testIndexedDotFile() throws IOException, InterruptedException {
        this.setupCountDown(2);
        Path path = this.getBasePath(this.getClass().getSimpleName()).resolve("dotFile.txt");
        this.ioService().write(path, "ooooo!", Collections.emptySet(), new FileAttribute[0]);
        this.ioService().write(path, "ooooo!", Collections.emptySet(), this.getFileAttributes());
        this.waitForCountDown(5000);
        MetaObject mo = this.config.getMetaModelStore().getMetaObject(Path.class.getName());
        Assert.assertNotNull((Object)mo);
        Assert.assertNotNull(mo.getProperty("name").get());
        Assert.assertEquals((long)1L, (long)((MetaProperty)mo.getProperty("name").get()).getTypes().size());
        Assert.assertTrue((boolean)((MetaProperty)mo.getProperty("name").get()).getTypes().contains(String.class));
        String index = KObjectUtil.toKCluster((FileSystem)path.getFileSystem()).getClusterId();
        TermQuery query = new TermQuery(new Term("name", "value"));
        long hits = this.config.getIndexProvider().findHitsByQuery(Arrays.asList(index), (Query)query);
        Assert.assertEquals((long)1L, (long)hits);
        this.config.dispose();
    }

    private FileAttribute<?>[] getFileAttributes() {
        return new FileAttribute[]{new FileAttribute<String>(){

            public String name() {
                return "name";
            }

            public String value() {
                return "value";
            }
        }};
    }
}

