/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata.io.analyzer;

import java.util.Collections;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.DelegatingAnalyzerWrapper;
import org.uberfire.ext.metadata.analyzer.ElasticSearchAnalyzer;
import org.uberfire.ext.metadata.analyzer.ElasticSearchAnalyzerWrapper;
import org.uberfire.ext.metadata.backend.lucene.analyzer.FilenameAnalyzer;

public class KiePerFieldAnalyzerWrapper
extends DelegatingAnalyzerWrapper
implements ElasticSearchAnalyzerWrapper {
    private final Analyzer defaultAnalyzer;
    private final Map<String, Analyzer> fieldAnalyzers;

    public KiePerFieldAnalyzerWrapper(Analyzer defaultAnalyzer) {
        this(defaultAnalyzer, null);
    }

    public KiePerFieldAnalyzerWrapper(Analyzer defaultAnalyzer, Map<String, Analyzer> fieldAnalyzers) {
        super(PER_FIELD_REUSE_STRATEGY);
        this.defaultAnalyzer = defaultAnalyzer;
        this.fieldAnalyzers = fieldAnalyzers != null ? fieldAnalyzers : Collections.emptyMap();
    }

    protected Analyzer getWrappedAnalyzer(String fieldName) {
        Analyzer analyzer = this.fieldAnalyzers.get(fieldName);
        return analyzer != null ? analyzer : this.defaultAnalyzer;
    }

    public String toString() {
        return "KiePerFieldAnalyzerWrapper(" + this.fieldAnalyzers + ", default=" + this.defaultAnalyzer + ")";
    }

    public String getFieldAnalyzer(String fieldName) {
        Analyzer analyzer = this.getWrappedAnalyzer(fieldName);
        Class<?> analyzerClass = analyzer.getClass();
        if (analyzerClass.equals(FilenameAnalyzer.class)) {
            return ElasticSearchAnalyzer.SIMPLE.toString();
        }
        return ElasticSearchAnalyzer.STANDARD.toString();
    }
}

