/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata.io.index;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.commons.lifecycle.PriorityDisposable;
import org.uberfire.commons.lifecycle.PriorityDisposableRegistry;
import org.uberfire.ext.metadata.backend.lucene.model.KClusterImpl;
import org.uberfire.ext.metadata.engine.MetaIndexEngine;
import org.uberfire.ext.metadata.engine.MetaModelStore;
import org.uberfire.ext.metadata.metamodel.MetaModelBuilder;
import org.uberfire.ext.metadata.model.KCluster;
import org.uberfire.ext.metadata.model.KObject;
import org.uberfire.ext.metadata.model.KObjectKey;
import org.uberfire.ext.metadata.provider.IndexProvider;

public class MetadataIndexEngine
implements MetaIndexEngine {
    private final MetaModelBuilder metaModelBuilder;
    private Logger logger = LoggerFactory.getLogger(MetadataIndexEngine.class);
    private final IndexProvider provider;
    private final Map<KCluster, AtomicInteger> batchMode = new ConcurrentHashMap<KCluster, AtomicInteger>();
    private final Map<KCluster, List<KObject>> batchSet = new ConcurrentHashMap<KCluster, List<KObject>>();
    private final Collection<Runnable> beforeDispose = new ArrayList<Runnable>();

    public MetadataIndexEngine(IndexProvider provider, MetaModelStore metaModelStore) {
        this.provider = provider;
        this.metaModelBuilder = new MetaModelBuilder(metaModelStore);
        PriorityDisposableRegistry.register((PriorityDisposable)this);
    }

    public boolean freshIndex(KCluster cluster) {
        boolean isFreshIndex;
        boolean bl = isFreshIndex = this.provider.isFreshIndex(cluster) && !this.batchMode.containsKey(cluster);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Is fresh index? " + isFreshIndex);
        }
        return isFreshIndex;
    }

    public void startBatch(KCluster cluster) {
        AtomicInteger batchStack = this.batchMode.get(cluster);
        if (batchStack == null) {
            this.batchMode.put(cluster, new AtomicInteger());
        } else if (batchStack.get() < 0) {
            batchStack.set(1);
        } else {
            batchStack.incrementAndGet();
        }
    }

    public void index(KObject kObject) {
        if (this.isBatch(kObject)) {
            KClusterImpl index = new KClusterImpl(kObject.getClusterId());
            this.batchSet.putIfAbsent((KCluster)index, new ArrayList());
            List<KObject> store = this.batchSet.get(index);
            store.add(kObject);
            this.batchSet.put((KCluster)index, store);
        } else {
            this.metaModelBuilder.updateMetaModel(kObject);
            this.provider.index(kObject);
        }
    }

    private boolean isBatch(KObject object) {
        AtomicInteger batchStack = this.batchMode.get(new KClusterImpl(object.getClusterId()));
        return batchStack != null && batchStack.get() > 0;
    }

    public void index(KObject ... objects) {
        ArrayList kObjects = Lists.newArrayList((Object[])objects);
        kObjects.forEach(kObject -> this.metaModelBuilder.updateMetaModel(kObject));
        this.provider.index((List)kObjects);
    }

    public void rename(KObjectKey from, KObject to) {
        PortablePreconditions.checkNotNull((String)"from", (Object)from);
        PortablePreconditions.checkNotNull((String)"to", (Object)to);
        PortablePreconditions.checkCondition((String)"renames are allowed only from same cluster", (boolean)from.getClusterId().equals(to.getClusterId()));
        this.provider.rename(from.getClusterId(), from.getId(), to);
    }

    protected boolean exists(KObjectKey from) {
        return this.provider.exists(from.getClusterId(), from.getId());
    }

    public void delete(KCluster cluster) {
        this.provider.delete(cluster.getClusterId());
    }

    public void delete(KObjectKey objectKey) {
        this.provider.delete(objectKey.getClusterId(), objectKey.getId());
    }

    public void delete(KObjectKey ... objectsKey) {
        Arrays.stream(objectsKey).forEach(kObjectKey -> this.delete((KObjectKey)kObjectKey));
    }

    public void commit(KCluster cluster) {
        int value;
        AtomicInteger batchStack = this.batchMode.get(cluster);
        if (batchStack != null && (value = batchStack.decrementAndGet()) > 0) {
            this.provider.index(this.batchSet.get(cluster));
            this.batchMode.remove(cluster);
            this.batchSet.remove(cluster);
        }
    }

    public void beforeDispose(Runnable callback) {
        this.beforeDispose.add((Runnable)PortablePreconditions.checkNotNull((String)"callback", (Object)callback));
    }

    public int priority() {
        return 50;
    }

    public void dispose() {
        if (!this.beforeDispose.isEmpty()) {
            for (Runnable activeDispose : this.beforeDispose) {
                activeDispose.run();
            }
        }
    }
}

