/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata.io.lucene;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.StreamSupport;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.WildcardQuery;
import org.jboss.byteman.contrib.bmunit.BMScript;
import org.jboss.byteman.contrib.bmunit.BMUnitRunner;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.uberfire.ext.metadata.io.KObjectUtil;
import org.uberfire.ext.metadata.io.lucene.BaseIndexTest;
import org.uberfire.ext.metadata.model.KObject;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.attribute.FileAttribute;

@RunWith(value=BMUnitRunner.class)
@BMScript(dir="byteman", value="lucene.btm")
public class IOServiceIndexedSortingTest
extends BaseIndexTest {
    @Override
    protected String[] getRepositoryNames() {
        return new String[]{this.getClass().getSimpleName()};
    }

    @Test
    public void testSortedFiles() throws IOException, InterruptedException {
        this.setupCountDown(4);
        Path base = this.writeFile("cFile1.txt");
        this.writeFile("CFile2.txt");
        this.writeFile("bFile.txt");
        this.writeFile("aFile.txt");
        this.waitForCountDown(5000);
        String index = KObjectUtil.toKCluster((Path)base).getClusterId();
        Sort sort = new Sort(new SortField("filenamesorted", SortField.Type.STRING));
        WildcardQuery query = new WildcardQuery(new Term("filename", "*.txt"));
        List hits = this.config.getIndexProvider().findByQuery(Arrays.asList(index), (Query)query, sort, Integer.MAX_VALUE);
        Assert.assertEquals((long)4L, (long)hits.size());
        Assert.assertEquals((Object)"aFile.txt", (Object)this.getProperty((KObject)hits.get(0), "filename"));
        Assert.assertEquals((Object)"bFile.txt", (Object)this.getProperty((KObject)hits.get(1), "filename"));
        Assert.assertEquals((Object)"cFile1.txt", (Object)this.getProperty((KObject)hits.get(2), "filename"));
        Assert.assertEquals((Object)"CFile2.txt", (Object)this.getProperty((KObject)hits.get(3), "filename"));
        this.config.dispose();
    }

    public String getProperty(KObject ko, String name) {
        return (String)StreamSupport.stream(ko.getProperties().spliterator(), false).filter(kProperty -> kProperty.getName().equals(name)).findAny().get().getValue();
    }

    private Path writeFile(String fileName) {
        Path path = this.getBasePath(this.getClass().getSimpleName()).resolve(fileName);
        this.ioService().write(path, "content", Collections.emptySet(), new FileAttribute[0]);
        return path;
    }
}

