/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata.io.infinispan;

import java.io.IOException;
import java.net.URI;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.jboss.byteman.contrib.bmunit.BMScript;
import org.jboss.byteman.contrib.bmunit.BMUnitRunner;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.commons.async.DescriptiveThreadFactory;
import org.uberfire.ext.metadata.engine.MetaIndexEngine;
import org.uberfire.ext.metadata.io.IOServiceIndexedImpl;
import org.uberfire.ext.metadata.io.MetadataConfigBuilder;
import org.uberfire.ext.metadata.io.infinispan.BaseIndexTest;
import org.uberfire.ext.metadata.model.KCluster;
import org.uberfire.io.IOService;
import org.uberfire.io.attribute.DublinCoreView;
import org.uberfire.java.nio.base.version.VersionAttributeView;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;

@RunWith(value=BMUnitRunner.class)
@BMScript(dir="byteman", value="infinispan.btm")
public class BatchIndexConcurrencyTest
extends BaseIndexTest {
    private MetaIndexEngine metaIndexEngine;

    @Override
    protected String[] getRepositoryNames() {
        return new String[]{"indexable-" + this.getClass().getSimpleName()};
    }

    @Override
    protected IOService ioService() {
        if (this.ioService == null) {
            this.config = new MetadataConfigBuilder("infinispan").withInMemoryMetaModelStore().useDirectoryBasedIndex().useInMemoryDirectory().build();
            this.metaIndexEngine = (MetaIndexEngine)Mockito.spy((Object)this.config.getIndexEngine());
            this.ioService = new IOServiceIndexedImpl(this.metaIndexEngine, Executors.newCachedThreadPool((ThreadFactory)new DescriptiveThreadFactory()), this.indexersFactory(), this.indexerDispatcherFactory(this.config.getIndexEngine()), new Class[]{DublinCoreView.class, VersionAttributeView.class}){

                protected void setupWatchService(FileSystem fs) {
                }
            };
        }
        return this.ioService;
    }

    @Test
    public void testSingleConcurrentBatchIndexExecution() throws IOException, InterruptedException {
        Path path1 = this.getBasePath("indexable-" + this.getClass().getSimpleName()).resolve("xxx");
        this.ioService().write(path1, "xxx!", new OpenOption[0]);
        this.setupCountDown(1);
        URI fsURI = URI.create("git://indexable-" + this.getClass().getSimpleName() + "/file1");
        CountDownLatch startSignal = new CountDownLatch(1);
        for (int i = 0; i < 3; ++i) {
            Runnable r = () -> {
                try {
                    startSignal.await();
                    this.ioService().getFileSystem(fsURI);
                }
                catch (InterruptedException e) {
                    Assert.fail((String)e.getMessage());
                }
            };
            new Thread(r).start();
        }
        startSignal.countDown();
        this.waitForCountDown(1000);
        Assert.assertEquals((long)1L, (long)this.getStartBatchCount());
        ((MetaIndexEngine)Mockito.verify((Object)this.metaIndexEngine, (VerificationMode)Mockito.times((int)3))).freshIndex((KCluster)Matchers.any(KCluster.class));
    }
}

