/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata.io.lucene;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.jboss.byteman.contrib.bmunit.BMScript;
import org.jboss.byteman.contrib.bmunit.BMUnitConfig;
import org.jboss.byteman.contrib.bmunit.BMUnitRunner;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.uberfire.ext.metadata.io.KObjectUtil;
import org.uberfire.ext.metadata.io.lucene.BaseIndexTest;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.attribute.FileAttribute;

@RunWith(value=BMUnitRunner.class)
@BMUnitConfig(debug=true)
@BMScript(dir="byteman", value="lucene.btm")
public class IOServiceIndexedDeleteFileTest
extends BaseIndexTest {
    @Override
    protected String[] getRepositoryNames() {
        return new String[]{this.getClass().getSimpleName()};
    }

    @Test
    public void testDeleteFile() throws IOException, InterruptedException {
        this.setupCountDown(1);
        Path path = this.getBasePath(this.getClass().getSimpleName()).resolve("delete-me.txt");
        this.ioService().write(path, "content", Collections.emptySet(), new FileAttribute[]{new FileAttribute<Object>(){

            public String name() {
                return "delete";
            }

            public Object value() {
                return "me";
            }
        }});
        this.waitForCountDown(5000);
        String index = KObjectUtil.toKCluster((FileSystem)path.getFileSystem()).getClusterId();
        TermQuery query = new TermQuery(new Term("delete", "me"));
        long hits = this.config.getIndexProvider().findHitsByQuery(Arrays.asList(index), (Query)query);
        Assert.assertEquals((long)1L, (long)hits);
        this.setupCountDown(2);
        this.ioService().delete(path, new DeleteOption[0]);
        this.waitForCountDown(5000);
        hits = this.config.getIndexProvider().findHitsByQuery(Arrays.asList(index), (Query)query);
        Assert.assertEquals((long)0L, (long)hits);
    }
}

