/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata.io.lucene;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.jboss.byteman.contrib.bmunit.BMScript;
import org.jboss.byteman.contrib.bmunit.BMUnitRunner;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.uberfire.ext.metadata.io.KObjectUtil;
import org.uberfire.ext.metadata.io.lucene.BaseIndexTest;
import org.uberfire.ext.metadata.model.schema.MetaProperty;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.attribute.FileAttribute;

@RunWith(value=BMUnitRunner.class)
@BMScript(dir="byteman", value="lucene.btm")
public class IOServiceIndexedGitImplTest
extends BaseIndexTest {
    protected final Date dateValue = new Date();

    @Override
    protected String[] getRepositoryNames() {
        return new String[]{this.getClass().getSimpleName()};
    }

    @Test
    public void testIndexedFile() throws IOException, InterruptedException {
        this.setupCountDown(2);
        Path path1 = this.getBasePath(this.getClass().getSimpleName()).resolve("myIndexedFile.txt");
        this.ioService().write(path1, "ooooo!", Collections.emptySet(), new FileAttribute[]{new FileAttribute<Object>(){

            public String name() {
                return "custom";
            }

            public Object value() {
                return IOServiceIndexedGitImplTest.this.dateValue;
            }
        }, new FileAttribute<String>(){

            public String name() {
                return "int.hello";
            }

            public String value() {
                return "hello some world jhere";
            }
        }, new FileAttribute<Integer>(){

            public String name() {
                return "int";
            }

            public Integer value() {
                return 10;
            }
        }});
        Path path2 = this.getBasePath(this.getClass().getSimpleName()).resolve("myOtherIndexedFile.txt");
        this.ioService().write(path2, "ooooo!", Collections.emptySet(), new FileAttribute[]{new FileAttribute<String>(){

            public String name() {
                return "int.hello";
            }

            public String value() {
                return "jhere";
            }
        }});
        this.waitForCountDown(5000);
        Assert.assertNotNull((Object)this.config.getMetaModelStore().getMetaObject(Path.class.getName()));
        Assert.assertNotNull(this.config.getMetaModelStore().getMetaObject(Path.class.getName()).getProperty("int").get());
        Assert.assertNotNull(this.config.getMetaModelStore().getMetaObject(Path.class.getName()).getProperty("int.hello").get());
        Assert.assertNotNull(this.config.getMetaModelStore().getMetaObject(Path.class.getName()).getProperty("custom").get());
        Assert.assertNotNull(this.config.getMetaModelStore().getMetaObject(Path.class.getName()).getProperty("int").get());
        Assert.assertNotNull(this.config.getMetaModelStore().getMetaObject(Path.class.getName()).getProperty("int.hello").get());
        Assert.assertNotNull(this.config.getMetaModelStore().getMetaObject(Path.class.getName()).getProperty("custom").get());
        Assert.assertEquals((long)1L, (long)((MetaProperty)this.config.getMetaModelStore().getMetaObject(Path.class.getName()).getProperty("int").get()).getTypes().size());
        Assert.assertEquals((long)1L, (long)((MetaProperty)this.config.getMetaModelStore().getMetaObject(Path.class.getName()).getProperty("int.hello").get()).getTypes().size());
        Assert.assertEquals((long)1L, (long)((MetaProperty)this.config.getMetaModelStore().getMetaObject(Path.class.getName()).getProperty("custom").get()).getTypes().size());
        Assert.assertTrue((boolean)((MetaProperty)this.config.getMetaModelStore().getMetaObject(Path.class.getName()).getProperty("int").get()).getTypes().contains(Integer.class));
        Assert.assertTrue((boolean)((MetaProperty)this.config.getMetaModelStore().getMetaObject(Path.class.getName()).getProperty("int.hello").get()).getTypes().contains(String.class));
        Assert.assertTrue((boolean)((MetaProperty)this.config.getMetaModelStore().getMetaObject(Path.class.getName()).getProperty("custom").get()).getTypes().contains(Date.class));
        String index = KObjectUtil.toKCluster((FileSystem)path2.getFileSystem()).getClusterId();
        TermQuery query = new TermQuery(new Term("int.hello", "world"));
        long hits = this.config.getIndexProvider().findHitsByQuery(Arrays.asList(index), (Query)query);
        Assert.assertEquals((long)1L, (long)hits);
        query = new TermQuery(new Term("int.hello", "jhere"));
        hits = this.config.getIndexProvider().findHitsByQuery(Arrays.asList(index), (Query)query);
        Assert.assertEquals((long)2L, (long)hits);
        long hits2 = this.config.getIndexProvider().findHitsByQuery(Arrays.asList(index), (Query)new MatchAllDocsQuery());
        Assert.assertEquals((long)2L, (long)hits2);
    }
}

