/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata.io;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.commons.async.DescriptiveRunnable;
import org.uberfire.ext.metadata.engine.Indexer;
import org.uberfire.ext.metadata.engine.MetaIndexEngine;
import org.uberfire.ext.metadata.engine.Observer;
import org.uberfire.ext.metadata.io.IndexersFactory;
import org.uberfire.ext.metadata.io.KObjectUtil;
import org.uberfire.ext.metadata.model.KCluster;
import org.uberfire.ext.metadata.model.KObject;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.base.FileSystemId;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.FileVisitResult;
import org.uberfire.java.nio.file.FileVisitor;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.SimpleFileVisitor;
import org.uberfire.java.nio.file.attribute.BasicFileAttributes;
import org.uberfire.java.nio.file.attribute.FileAttribute;
import org.uberfire.java.nio.file.attribute.FileAttributeView;

public final class BatchIndex {
    private static final Logger LOG = LoggerFactory.getLogger(BatchIndex.class);
    private final MetaIndexEngine indexEngine;
    private final IOService ioService;
    private final Class<? extends FileAttributeView>[] views;
    private final AtomicBoolean indexDisposed = new AtomicBoolean(false);
    private final Observer observer;
    private final ExecutorService executorService;

    @SafeVarargs
    public BatchIndex(MetaIndexEngine indexEngine, IOService ioService, Observer observer, ExecutorService executorService, Class<? extends FileAttributeView> ... views) {
        this.indexEngine = (MetaIndexEngine)PortablePreconditions.checkNotNull((String)"indexEngine", (Object)indexEngine);
        this.ioService = (IOService)PortablePreconditions.checkNotNull((String)"ioService", (Object)ioService);
        this.observer = (Observer)PortablePreconditions.checkNotNull((String)"observer", (Object)observer);
        this.views = views;
        this.executorService = executorService;
    }

    public void runAsync(final FileSystem fs) {
        if (fs != null && fs.getRootDirectories().iterator().hasNext()) {
            this.executorService.execute((Runnable)new DescriptiveRunnable(){

                public String getDescription() {
                    return "FS BatchIndex [" + ((FileSystemId)fs).id() + "]";
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    final AtomicBoolean indexFinished = new AtomicBoolean(false);
                    BatchIndex.this.indexEngine.beforeDispose(new Runnable(){

                        @Override
                        public void run() {
                            BatchIndex.this.indexDisposed.set(true);
                            if (!indexFinished.get()) {
                                BatchIndex.this.indexEngine.delete(KObjectUtil.toKCluster(fs));
                            }
                        }
                    });
                    KCluster cluster = null;
                    try {
                        cluster = KObjectUtil.toKCluster(fs);
                        BatchIndex.this.indexEngine.startBatch(cluster);
                        for (Path root : fs.getRootDirectories()) {
                            BatchIndex.this.run(root);
                        }
                        indexFinished.set(true);
                    }
                    catch (Exception ex) {
                        if (!BatchIndex.this.indexDisposed.get()) {
                            BatchIndex.this.logError("FileSystem Index fails. [@" + fs.toString() + "]", ex);
                        }
                    }
                    finally {
                        if (cluster != null) {
                            if (indexFinished.get()) {
                                BatchIndex.this.indexEngine.commit(cluster);
                            } else {
                                BatchIndex.this.indexEngine.abort(cluster);
                            }
                        }
                    }
                }
            });
        }
    }

    public void runAsync(final Path root) {
        this.executorService.execute((Runnable)new DescriptiveRunnable(){

            public String getDescription() {
                return "Path BatchIndex [" + root.toString() + "]";
            }

            public void run() {
                BatchIndex.this.run(root);
            }
        });
    }

    public void run(Path root) {
        this.run(root, null);
    }

    public void run(final Path root, Runnable callback) {
        try {
            if (root == null) {
                return;
            }
            this.logInformation("Starting indexing of " + root.toUri() + " ...");
            Files.walkFileTree((Path)((Path)PortablePreconditions.checkNotNull((String)"root", (Object)root)), (FileVisitor)new SimpleFileVisitor<Path>(){

                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (BatchIndex.this.indexDisposed.get()) {
                        return FileVisitResult.TERMINATE;
                    }
                    try {
                        PortablePreconditions.checkNotNull((String)"file", (Object)file);
                        PortablePreconditions.checkNotNull((String)"attrs", (Object)attrs);
                        if (!file.getFileName().toString().startsWith(".")) {
                            LOG.debug("Indexing " + file.toUri());
                            for (Class view : BatchIndex.this.views) {
                                BatchIndex.this.ioService.getFileAttributeView(file, view);
                            }
                            FileAttribute[] allAttrs = BatchIndex.this.ioService.convert(BatchIndex.this.ioService.readAttributes(file));
                            if (BatchIndex.this.indexDisposed.get()) {
                                return FileVisitResult.TERMINATE;
                            }
                            BatchIndex.this.indexEngine.index(KObjectUtil.toKObject(file, allAttrs));
                            for (Indexer indexer : IndexersFactory.getIndexers()) {
                                KObject kObject;
                                if (!file.getFileSystem().isOpen() || !indexer.supportsPath(file) || (kObject = indexer.toKObject(file)) == null) continue;
                                if (!BatchIndex.this.indexDisposed.get()) {
                                    BatchIndex.this.indexEngine.index(kObject);
                                    continue;
                                }
                                return FileVisitResult.TERMINATE;
                            }
                        }
                    }
                    catch (Exception ex) {
                        if (BatchIndex.this.indexDisposed.get()) {
                            BatchIndex.this.logWarning("Batch index couldn't finish. [@" + root.toUri().toString() + "]");
                            return FileVisitResult.TERMINATE;
                        }
                        BatchIndex.this.logError("Index fails. [@" + file.toString() + "]", ex);
                    }
                    if (BatchIndex.this.indexDisposed.get()) {
                        return FileVisitResult.TERMINATE;
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
            if (!this.indexDisposed.get()) {
                this.logInformation("Completed indexing of " + root.toUri());
                if (callback != null) {
                    callback.run();
                }
            } else {
                this.logWarning("Batch index couldn't finish. [@" + root.toUri().toString() + "]");
            }
        }
        catch (IllegalStateException ex) {
            if (this.indexDisposed.get()) {
                this.logWarning("Batch index couldn't finish. [@" + root.toUri().toString() + "]");
            } else {
                this.logError("Index fails - Index has an invalid state. [@" + root.toUri().toString() + "]", ex);
            }
        }
        catch (Exception ex) {
            if (this.indexDisposed.get()) {
                this.logWarning("Batch index couldn't finish. [@" + root.toUri().toString() + "]");
            }
            this.logError("Index fails. [@" + root.toUri().toString() + "]", ex);
        }
    }

    private void logInformation(String message) {
        this.observer.information(message);
        LOG.info(message);
    }

    private void logWarning(String message) {
        this.observer.warning(message);
        LOG.warn(message);
    }

    private void logError(String message, Throwable throwable) {
        this.observer.error(message);
        LOG.error(message, throwable);
    }

    public void dispose() {
        this.indexEngine.dispose();
    }
}

